------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                 --
--                                                                          --
--                              EPHEMERIS.FLAGS                             --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.3 $
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

-- Swiss Ephemeris Calculation Flags Management (Incomplete)

with Interfaces; use Interfaces;
package Ephemeris.Flags is
   -- Swiss Ephemeris calculation flags:
   function Calculation_Flags return Unsigned_32;

   -- Flag manipulations:

   -- Set all flags to 0:
   procedure Reset_Flags;

   -- Ephemeris selection:
   procedure Use_Swiss;
   procedure Use_JPL;
   procedure Use_Moshier;

   -- Apparent vs true positions:
   procedure Use_True_Positions;
   procedure Use_Apparent_Positions;
   procedure Generate_Velocities;
   procedure No_Velocities;
   procedure Use_Aberration;
   procedure No_Aberration;
   procedure Use_Gravitational_Deflection;
   procedure No_Gravitational_Deflection;
   procedure Use_Light_Time;
   procedure No_Light_Time;
   procedure Use_Nutation;
   procedure No_Nutation;

   -- Coordinate format:
   procedure Use_Cartesian;
   procedure Use_Rectangular renames Use_Cartesian;
   procedure Use_Polar;
   procedure Use_Degrees;
   procedure Use_Radians;

   -- Coordinate center:
   procedure Use_Topocentric;
   procedure Use_Geocentric;
   procedure Use_Heliocentric;

   -- Coordinate plane:
   procedure Use_Ecliptical;
   procedure Use_Equatorial;

   -- Coordinate reference point:
   procedure Use_Sidereal;
   procedure Use_Tropical;

   -- Reference equinox for calculations:
   procedure Use_Equinox_Of_Date;
   procedure Use_J2000_Equinox;

private
   -- Flag accessors. Taken from Swephprg.html:

   -- Ephemeris selection:
   JPL : constant Unsigned_32 := 1;
   Swiss : constant Unsigned_32 := 2;
   Moshier : constant Unsigned_32 := 4;

   -- Apparent vs true positions:
   True_Positions : constant Unsigned_32 := 16;
   Aberration_Off : constant Unsigned_32 := 1024;
   Gravitational_Deflection_Off : constant Unsigned_32 := 512;
   Nutation_Off : constant Unsigned_32 := 64;

   -- Coordinate format:
   Cartesian : constant Unsigned_32 := 4096;
   Radians : constant Unsigned_32 := 8192;

   -- Coordinate center:
   Topocentric : constant Unsigned_32 := 32 * 1024;
   Heliocentric : constant Unsigned_32 := 8;

   -- Coordinate plane:
   Equatorial : constant Unsigned_32 := 2048;

   -- Coordinate reference point:
   Sidereal : constant Unsigned_32 := 64 * 1024;

   -- Reference equinox for calculations:
   J2000 : constant Unsigned_32 := 32;

   -- Other:
   Velocities : constant Unsigned_32 := 256;

end Ephemeris.Flags;
