------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                              ASPECT_MODELS                               --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.3 $
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------
with MVC; use MVC;
with Aspect_Selections; use Aspect_Selections;

--  Models of aspect selections
package Aspect_Models is

   type Aspect_Model is new Model_Obj with private;
   type Aspect_Model_Ptr is access all Aspect_Model'Class;

   ---------------
   --  Queries  --
   ---------------

   function Selection (M : access Aspect_Model)
                      return Aspect_Selection;

   ------------------------
   --  Basic Operations  --
   ------------------------

   procedure Update (M : access Aspect_Model;
                     Selection : Aspect_Selection);

private
   type Aspect_Model is new Model_Obj with record
      Selection : Aspect_Selection;
   end record;

end Aspect_Models;
