------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                             BODY_CONTROLLERS                             --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.3 $                             --
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with Body_Dialog_Pkg; use Body_Dialog_Pkg;
with Body_Views; use Body_Views;
with Main_Models;
with Event_Models;

--  Controller for body selection dialog
package body Body_Controllers is

   ----------------------
   --  Initialization  --
   ----------------------

   --  Set up controller
   procedure Initialize
     (C : access Body_Controller;
      M : access Model_Obj'Class;
      V : access View_Obj'Class;
      Selector_Controller : access Body_Selector_Controller'Class) is

   begin
      --  Call super initialization
      Initialize (Controller_Obj (C.all)'Access, M, V);

      C.Dialog := Dialog (Body_View (V.all)'Access);
      C.Selector :=
        Body_Selector_Controller_Ptr'(Selector_Controller.all'Access);
   end Initialize;


   ------------------------
   --  Basic Operations  --
   ------------------------

   --  Set up the open dialog state from the model
   procedure Reset_Dialog_State (This : access Body_Controller) is
   begin
      Reset_Selector_State (This.Selector);
   end Reset_Dialog_State;

   procedure Update_All
     (This : access Body_Controller;
      Opening_Dialog : Boolean := False) is

      use Main_Models;
      Main : Main_Model_Ptr
        := Main_Model_Ptr'(Main_Model (Model (This).all)'Access);
   begin
      if This.Selector /= null then
         Update_All (This.Selector, Opening_dialog);
         --  Notify all events and their views to update.  Could make event
         --  views observers of body_model to simplify this
         Start (Main);
         while not Off (Main) loop
            Event_Models.Update_All
              (Item (Main),
               new Event_Models.Update_Event,
               Suppress_Main_Update => True);
            Forth (Main);
         end loop;
      end if;
   end Update_All;

   --  Delete dialog
   procedure Delete_Dialog (This : access Body_Controller) is
   begin
      Hide_All (This.Dialog);
      Reset_Dialog_State (This);
   end Delete_Dialog;

   --  Undisplay the dialog
   procedure Undisplay (This : access Body_Controller) is
   begin
      Hide_All (This.Dialog);
   end Undisplay;

   --  Display the dialog
   procedure Display (This : access Body_Controller) is
   begin
      Show_All (This.Dialog);
   end Display;

end Body_Controllers;
