------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                              BODY_CONTROLLERS                            --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.3 $                             --
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with MVC; use MVC;

with Body_Dialog_Pkg; use Body_Dialog_Pkg;
with Body_Selector_Controllers; use Body_Selector_Controllers;

with Event_Controllers;

--  Controller for body selection dialog
package Body_Controllers is

   type Body_Controller is new Controller_Obj with private;
   type Body_Controller_Ptr is access all Body_Controller'Class;

   Invalid_Input : exception
     renames Event_Controllers.Invalid_Input;

   ----------------------
   --  Initialization  --
   ----------------------

   --  Set up controller
   procedure Initialize
     (C : access Body_Controller;
      M : access Model_Obj'Class;
      V : access View_Obj'Class;
      Selector_Controller : access Body_Selector_Controller'Class);

   ------------------------
   --  Basic Operations  --
   ------------------------

   --  Set up the open dialog state to reflect the model in preparation for
   --  modifications by user
   procedure Reset_Dialog_State (This : access Body_Controller);

   --  Commit changes made in the open dialog to the model
   procedure Update_All
     (This : access Body_Controller; Opening_Dialog : Boolean := False);

   --  Delete the dialog
   procedure Delete_Dialog (This : access Body_Controller);

   --  Undisplay the dialog
   procedure Undisplay (This : access Body_Controller);

   --  Display the dialog
   procedure Display (This : access Body_Controller);

private
   type Body_Controller is new Controller_Obj with record
      Dialog : Body_Dialog_Access;
      Selector : Body_Selector_Controller_Ptr;
   end record;

   pragma Inline (Initialize);
   pragma Inline (Display, Undisplay);
end Body_Controllers;
