------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                        BODY_SELECTOR_CONTROLLERS                         --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.3 $
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with Gtk.Check_Button; use Gtk.Check_Button;

with Body_Selector; use Body_Selector;
with Body_Models; use Body_Models;
with Event_Controllers; use Event_Controllers;

with MVC; use MVC;

--  Controllers for body selection widgets
package Body_Selector_Controllers is
   type Body_Selector_Controller is new Controller_Obj with private;
   type Body_Selector_Controller_Ptr is
     access all Body_Selector_Controller'Class;

   Invalid_Input : exception
     renames Event_Controllers.Invalid_Input;

   ----------------------
   --  Initialization  --
   ----------------------

   --  Set up controller
   procedure Initialize
     (C : access Body_Selector_Controller;
      M : access Model_Obj'Class;
      V : access View_Obj'Class);

   ------------------------
   --  Basic Operations  --
   ------------------------

   --  Set selector to model values
   procedure Reset_Selector_State (This : access Body_Selector_Controller);

    --  Update open dialog state to reflect a change to one body
   procedure Update
     (This : access Body_Selector_Controller;
      Button : access Gtk_Check_Button_Record'Class);

   --  Add an extended body to the dialog
   procedure Add_Extended_Body (This : access Body_Selector_Controller);

   --  Delete currently selected extended bodies
   procedure Delete_Extended_Bodies (This : access Body_Selector_Controller);

   --  Clear the extended bodies list in the dialog
   procedure Clear_Extended_Bodies (This : access Body_Selector_Controller);

   --  Commit changes made in the open dialog to the model
   procedure Update_All
     (This : access Body_Selector_Controller;
      Opening_Dialog : Boolean);

private
   type Body_Selector_Controller is new Controller_Obj with record
      Selector : Body_Selectors_Access;

      --  Temporary state of basic bodies while body dialog is open.
      --  The state of the extended bodies is maintained directly in
      --  the dialog list while it's open
      Button_List_State : Basic_Bodies_Array;
   end record;

   pragma Inline (Initialize);
   pragma Inline (Clear_Extended_Bodies, Delete_Extended_Bodies);
end Body_Selector_Controllers;
