------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                                BODY_VIEWS                                --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.3 $
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with Publish_Subscribe; use Publish_Subscribe;
with MVC; use MVC;

with Body_Dialog_Pkg; use Body_Dialog_Pkg;
with Body_Controllers; use Body_Controllers;

--  View for body selection dialog.
package Body_Views is

   type Body_View is new View_Obj with private;
   type Body_View_Ptr is access all Body_View'Class;

   ----------------------
   --  Initialization  --
   ----------------------

   --  Initialize view and controller. M is a Main_Model
   procedure Initialize
     (This : access Body_View; M : access Model_Obj'Class);


   ---------------
   --  Queries  --
   ---------------

   --  Access the view's controller
   function Controller (This : access Body_View) return Body_Controller_Ptr;

   --  Access the view's GTK+ dialog
   function Dialog (This : access Body_View) return Body_Dialog_Access;

private
   --  Update operation for the dialog
   procedure Update(This: access Body_View;
                    Source: access Observable'Class;
                    Evt: access Event'Class);

   type Body_View is new View_Obj with record
      Controller : Body_Controller_Ptr;
      Dialog : Body_Dialog_Access;
   end record;

   pragma Inline (Controller, Dialog);
end Body_Views;
