------------------------------------------------------------------------------
--                                                                          --
--                              AstroFrames                                 --
--                                                                          --
--                            EVENT_CONTROLLERS                             --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.3 $                             --
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with MVC; use MVC;

with Event_Dialog_Pkg; use Event_Dialog_Pkg;

--  Controller for an event specification dialog
package Event_Controllers is

   type Event_Controller is new Controller_Obj with private;
   type Event_Controller_Ptr is access all Event_Controller'Class;

   --  Raise on invalid value in an input field
   Invalid_Input : exception;

   ----------------------
   --  Initialization  --
   ----------------------

   --  Set up controller for event specification
   procedure Initialize
     (C : access Event_Controller;
      M : access Model_Obj'Class;
      V : access View_Obj'Class);


   ------------------------
   --  Basic Operations  --
   ------------------------

   --  Close an event dialog
   procedure Close_Dialog (This : access Event_Controller);

   --  Open event dialog
   procedure Open_Dialog (This : access Event_Controller);

   --  Open notes textbox
   procedure Open_Notes (This : access Event_Controller);

   --  Reset modified flag
   procedure Reset_Modified (This : access Event_Controller);

   --  Set modified flag
   procedure Set_Modified (This : access Event_Controller);

   --  Update all active views
   procedure Update_All (This : access Event_Controller);

private
   type Event_Controller is new Controller_Obj with record
      Dialog : Event_Dialog_Access;
   end record;

   pragma Inline (Open_Dialog, Close_Dialog);
   pragma Inline (Set_Modified, Reset_Modified);

end Event_Controllers;
