------------------------------------------------------------------------------
--                                                                          --
--                              AstroFrames                                 --
--                                                                          --
--                          EVENT_MODELS.PERSISTENCE                        --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.3 $                             --
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

--  Facility for saving and restoring events
package Event_Models.Persistence is

   ---------------
   --  Queries  --
   ---------------

   --  Event status (true if modified and not saved to disk)
   function Modified (This : access Event_Model'Class) return Boolean;

   --  Last filespec for the event
   function File_Spec (This : access Event_Model'Class) return String;

   -----------------------
   --  Basic Operations --
   -----------------------

   --  Reset modified flag.  Called when an event is saved to disk
   procedure Reset_Modified (This : access Event_Model'Class);

   --  Set file spec for persisting event
   procedure Set_File_Spec
     (Model : access Event_Model'Class; Spec : String);

   --  Set modified bit.  Called when an event changes relative to its
   --  saved disk state
   procedure Set_Modified (This : access Event_Model'Class);

   --  Save event to disk
   procedure Persist (This : access Event_Model'Class);

   --  Restore an event from disk
   function Restore (Spec : String) return Event_Model_Ptr;

private
   pragma Inline (Modified, Set_Modified, Reset_Modified);
   pragma Inline (File_Spec, Set_File_Spec);
end Event_Models.Persistence;
