------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                      FILTER_PRIMARIES_CONTROLLERS                        --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.4 $
--                                                                          --
--                       Copyright (C) 2002 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with Filter_Primaries_Views; use Filter_Primaries_Views;

--  Controller for filtering primary directions.
package body Filter_Primaries_Controllers is


   ----------------------
   --  Initialization  --
   ----------------------

   --  Set up controller for event specification
   procedure Initialize
     (C : access Filter_Primaries_Controller;
      M : access Model_Obj'Class;
      V : access View_Obj'Class) is
   begin
      --  Call super initialization
      Initialize (Controller_Obj (C.all)'Access, M, V);

      C.Dialog := Dialog (Filter_Primaries_View (V.all)'Access);
   end Initialize;

   ------------------------
   --  Basic Operations  --
   ------------------------

   --  Close the primary directions filtering dialog
   procedure Close (This : access Filter_Primaries_Controller) is
   begin
      Close (Filter_Primaries_View (View (This).all)'Access);
   end Close;

   --  Open dialog
   procedure Open_Dialog (This : access Filter_Primaries_Controller) is
   begin
      Open (Filter_Primaries_View (View (This).all)'Access);
   end Open_Dialog;

   --  Record settings from dialog
   procedure Update_All (This : access Filter_Primaries_Controller) is
   begin
      null;
   end Update_All;

end Filter_Primaries_Controllers;
