------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                      FILTER_PRIMARIES_CONTROLLERS                        --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.4 $
--                                                                          --
--                       Copyright (C) 2002 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with MVC; use MVC;
with Filter_Primaries_Dialog_Pkg; use Filter_Primaries_Dialog_Pkg;

--  Controller for filtering primary directions.
package Filter_Primaries_Controllers is

   type Filter_Primaries_Controller is new Controller_Obj with private;
   type Filter_Primaries_Controller_Ptr is
     access all Filter_Primaries_Controller'Class;

   ----------------------
   --  Initialization  --
   ----------------------

   --  Set up controller for event specification
   procedure Initialize
     (C : access Filter_Primaries_Controller;
      M : access Model_Obj'Class;
      V : access View_Obj'Class);

   ------------------------
   --  Basic Operations  --
   ------------------------

   --  Close the primary directions filtering dialog
   procedure Close (This : access Filter_Primaries_Controller);

   --  Open dialog
   procedure Open_Dialog (This : access Filter_Primaries_Controller);

   --  Record settings from dialog
   procedure Update_All (This : access Filter_Primaries_Controller);

private
   type Filter_Primaries_Controller is new Controller_Obj with record
      Dialog : Filter_Primaries_Dialog_Access;
   end record;

   pragma Inline (Close, Open_Dialog);

end Filter_Primaries_Controllers;
