------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                          FILTER_PRIMARIES_VIEWS                          --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.4 $
--                                                                          --
--                       Copyright (C) 2002 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with Publish_Subscribe; use Publish_Subscribe;
with MVC; use MVC;

with Filter_Primaries_Dialog_Pkg; use Filter_Primaries_Dialog_Pkg;
with Filter_Primaries_Controllers; use Filter_Primaries_Controllers;
with Filter_Panels_Views; use Filter_Panels_Views;

--  View for filtering primary directions.
package Filter_Primaries_Views is

   type Filter_Primaries_View is new View_Obj with private;
   type Filter_Primaries_View_Ptr is access all Filter_Primaries_View'Class;

   ----------------------
   --  Initialization  --
   ----------------------

   --  Set up view and controller
   procedure Initialize
     (This : access Filter_Primaries_View; M : access Model_Obj'Class);

   ---------------
   --  Queries  --
   ---------------

   --  Reference to controller
   function Controller (This : access Filter_Primaries_View)
                       return Filter_Primaries_Controller_Ptr;

   --  Reference to the dialog
   function Dialog (This : access Filter_Primaries_View)
                   return Filter_Primaries_Dialog_Access;

   ------------------------
   --  Basic Operations  --
   ------------------------

   --  Close the primary directions filtering dialog
   procedure Close (This : access Filter_Primaries_View);

   --  Open the primary directions filtering dialog
   procedure Open (This : access Filter_Primaries_View);

private

   --  Update operation
   procedure Update
     (This : access Filter_Primaries_View;
      Source : access Observable'Class;
      Evt : access Event'Class);

   type Filter_Primaries_View is new View_Obj with record
      Controller : Filter_Primaries_Controller_Ptr;
      Dialog  : Filter_Primaries_Dialog_Access;
      Promissors, Significators : aliased Filter_Panels_View;
   end record;

   pragma Inline (Dialog, Controller, Open, Close);

end Filter_Primaries_Views;
