------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                 --
--                                                                          --
--                              LOCATION_VIEWS                              --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.4 $                             --
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with Main_Models; use Main_Models;

with Times.Strings; use Times.Strings;
with Locations.Strings; use Locations.Strings;

with Gtk.Gentry; use Gtk.Gentry;
with Gtk.Check_Button; use Gtk.Check_Button;

--  View for default location dialog
package body Location_Views is

   ----------------------
   --  Initialization  --
   ----------------------

   --  Intialize view and controller
   procedure Initialize
     (This : access Location_View;
      M : access Model_Obj'Class) is
   begin
      --  Parent initialization
      MVC.Initialize (View_Obj (This.all)'access, M);
      Add_Observer (M, Observer_Ptr (This));

      --  Create dialog and controller
      Gtk_New (This.Dialog);
      This.Controller := new Location_Controller;

      --  Initialize dialog
      Location_Dialog_Pkg.Initialize
        (This.Dialog, Controller_Ptr'(This.Controller.all'Access));

      --  Initialize controller
      Location_Controllers.Initialize
        (This.Controller, M, This);

   end Initialize;


   ---------------
   --  Queries  --
   ---------------

   --  Access to controller
   function Controller (This : access Location_View)
                       return Location_Controller_Ptr is
   begin
      return This.Controller;
   end Controller;

   --  Reference to dialog
   function Dialog (This : access Location_View)
                   return Location_Dialog_Access is
   begin
      return This.Dialog;
   end Dialog;


   ------------------------
   --  Basic Operations  --
   ------------------------

   --  Update default location dialog from main model and display it
   procedure Update
     (This : access Location_View;
      Source : access Observable'Class;
      Evt : access Event'Class) is

      M : Main_Model_Ptr := Main_Model (Source.all)'Access;
      Alt_String : String := Altitude_String (Default_Location (M).Alt);
   begin
      if Evt.all in Update_Event'Class then

         --  Set latitude
         Set_Text (This.Dialog.Lat_Degree,
                   Latitude_Degrees_String (Default_Location (M).Lat));

         Set_Text (This.Dialog.Lat_Minute,
                   Latitude_Minutes_String (Default_Location (M).Lat));

         Set_Text (This.Dialog.Lat_Second,
                   Latitude_Seconds_String (Default_Location (M).Lat));

         Set_Text (This.Dialog.Lat_Direction,
                   Latitude_Hemisphere_String (Default_Location (M).Lat));


         -- Set longitude
         Set_Text (This.Dialog.Long_Degree,
                   Longitude_Degrees_String (Default_Location (M).Long));

         Set_Text (This.Dialog.Long_Minute,
                   Longitude_Minutes_String (Default_Location (M).Long));

         Set_Text (This.Dialog.Long_Second,
                   Longitude_Seconds_String (Default_Location (M).Long));

         Set_Text (This.Dialog.Long_Direction,
                   Longitude_Hemisphere_String (Default_Location (M).Long));


         --  Set altitude
         Set_Text (This.Dialog.Alt_Entry,
                   Alt_String (1 .. Alt_String'Last - 2));


         --  Fill time zone strings into dialog
         Set_Text (This.Dialog.Zone_Hour,
                   Hour_String (abs Default_Time_Zone (M)));
         Set_Text (This.Dialog.Zone_Minute,
                   Minute_String (abs Default_Time_Zone (M)));
         Set_Text (This.Dialog.Zone_Direction,
                   Zone_Hemi_String (Default_Time_Zone (M)));

         --  Fill checkbox for generating a startup event
         Set_Active
           (This.Dialog.Startup_Event_Button,
            Startup_Event (M));

         Grab_Default (This.Dialog.Lat_Degree);
         Grab_Focus (This.Dialog.Lat_Degree);
         Select_Region (This.Dialog.Lat_Degree, 0);
      end if;
   end Update;

end Location_Views;
