------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                             MAIN_CONTROLLERS                             --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                             $Revision: 1.4 $
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with MVC; use MVC;

with Main_Window_Pkg; use Main_Window_Pkg;
with Event_Models; use Event_Models;

with Gtk.Clist; use Gtk.Clist;

--  Main window controller
package Main_Controllers is
   type Main_Controller is new Controller_Obj with  private;
   type Main_Controller_Ptr is access all Main_Controller'Class;

   --  Private data for main window "Event_Table".  Necessary to tag the
   --  rows since they can be reordered relative to the model of the table.
   --  With this mechanism, the individual event models can be correctly
   --  accessed
   package Identification is new Row_Data (Event_Model_Ptr);
   use Identification;

   ----------------------
   --  Initialization  --
   ----------------------

   --  Initialize controller from view
   procedure Initialize (C : access Main_Controller;
                         M : access Model_Obj'Class;
                         V : access View_Obj'Class);


   ------------------------
   --  Basic Operations  --
   ------------------------

   --  Clone a single event
   procedure Clone
     (This : access Main_Controller;
      Event : Event_Model_Ptr);

   --  Clone the selected events
   procedure Clone_Selected_Events (This : access Main_Controller);

   --  Delete selected events from main window
   procedure Delete_Selected_Events (This : access Main_Controller);

   --  Display all enabled views for the selected events
   procedure Display_Selected_Events (This : access Main_Controller);

   --  Open primaries filtering preferences dialog
   procedure Filter_Primaries (This : access Main_Controller);

   --  Modify the selected events
   procedure Modify_Selected_Events (This : access Main_Controller);

   --  Open the dialog for specifying a new event
   procedure New_Event (This : access Main_controller);

   --  Open primary directions list dialog
   procedure Primary_Directions_Event (This : access Main_Controller);

   --  Quit application
   procedure Quit_Event (This : access Main_Controller);

   --  Restore an event from disk
   procedure Restore_Event (This : access Main_Controller);

   --  Save all modified events to disk
   procedure Save_Modified_Events (This : access Main_Controller);

   --  Save the selected events to disk
   procedure Save_Selected_Events (This : access Main_Controller);

   --  Select topocentric apparent coordinates
   procedure Select_Apparent_Coordinates (This : access Main_Controller);

   --  Select bodies to display in the event views
   procedure Select_Bodies_Event (This : access Main_Controller);

   --  Select Conventional Chart display
   procedure Select_Conventional_Chart (This : access Main_Controller);

   --  Select topocentric apparent coordinates
   procedure Select_Conventional_Coordinates (This : access Main_Controller);

   --  Select Lunar Zodiac display
   procedure Select_Lunar_Zodiac (This : access Main_Controller);

   --  Select Solar Zodiac display
   procedure Select_Solar_Zodiac (This : access Main_Controller);

   --  Select Terrestrial Zodiac display
   procedure Select_Terrestrial_Zodiac (This : access Main_Controller);

   --  Select Table of Positions display
   procedure Select_Table_Of_Positions (This : access Main_Controller);

   --  Select topocentric apparent coordinates
   procedure Select_True_Coordinates (This : access Main_Controller);

   --  Set the default location
   procedure Set_Default_Location (This : access Main_Controller);

   --  Set the root directory for saving and restoring events
   procedure Set_Event_Directory (This : access Main_Controller);

private
   type Main_Controller is new Controller_Obj with record
      Window : Main_Window_Access;
   end record;

   pragma Inline (Initialize, Select_Bodies_Event, Set_Default_Location);
   pragma Inline (Filter_Primaries);
end Main_Controllers;
