------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                 --
--                                                                          --
--                                MAIN_VIEWS                                --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.4 $                             --
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with Publish_Subscribe; use Publish_Subscribe;
with MVC; use MVC;

with Main_Window_Pkg; use Main_Window_Pkg;
with Main_Controllers; use Main_Controllers;

with Body_Views; use Body_Views;
with Location_Views; use Location_Views;
with Filter_Primaries_Views; use Filter_Primaries_Views;

--  View for main window list of events
package Main_Views is
   type Main_View is new View_Obj with private;
   type Main_View_Ptr is access all Main_View'Class;

   ----------------------
   --  Initialization  --
   ----------------------

   --  Set up view and controller
   procedure Initialize
     (This : access Main_View; M : access Model_Obj'Class);


   ---------------
   --  Queries  --
   ---------------

   --  Access to the main GTK+ window
   function Window (This : access Main_View) return Main_Window_Access;


   ------------------------
   --  Basic Operations  --
   ------------------------

   --  Trigger popup of body selection dialog
   procedure Display_Bodies_Dialog (This : access Main_View);

   --  Trigger popup of primaries filtering dialog
   procedure Display_Filter_Primaries_Dialog (This : access Main_View);

   --  Trigger popup of default location dialog
   procedure Display_Location_Dialog (This : access Main_View);

private

   --  Update operation.  Causes visual update of event list
   procedure Update
     (This : access Main_View;
      Source : access Observable'Class;
      Evt : access Event'Class);

   type Main_View is new View_Obj with record
      Controller : Main_Controller_Ptr;
      Window  : Main_Window_Access;
      Body_View : Body_View_Ptr;
      Location_View : Location_View_Ptr;
      Filter_Primaries_View : Filter_Primaries_View_Ptr;
   end record;

   pragma Inline (Window, Display_Location_Dialog,
                  Display_Filter_Primaries_Dialog);
end Main_Views;
