------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                 --
--                                                                          --
--                             NOTES_CONTROLLERS                            --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.3 $                             --
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with MVC; use MVC;

with Notes_Dialog_Pkg; use Notes_Dialog_Pkg;

--  Controller for event notes dialog
package Notes_Controllers is

   type Notes_Controller is new Controller_Obj with private;
   type Notes_Controller_Ptr is access all Notes_Controller'Class;


   ----------------------
   --  Initialization  --
   ----------------------

   --  Set up controller for notes
   procedure Initialize
     (C : access Notes_Controller;
      M : access Model_Obj'Class;
      V : access View_Obj'Class);

   ------------------------
   --  Basic Operations  --
   ------------------------

   --  Cancel updates made to dialog
   procedure Cancel (This : access Notes_Controller);

   --  Display the dialog
   procedure Display (This : access Notes_Controller);

   --  Undisplay the dialog
   procedure Undisplay (This : access Notes_Controller);

   --  Commit changes made in dialog to the model
   procedure Update_All (This : access Notes_Controller);

private
   type Notes_Controller is new Controller_Obj with record
      Dialog : Notes_Dialog_Access;
   end record;

   pragma Inline (Display, Undisplay);
end Notes_Controllers;
