------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                 --
--                                                                          --
--                           POSITIONS_CONTROLLERS                          --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.3 $                             --
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with Positions_Views; use Positions_Views;

with Event_Models; use Event_Models;
with Main_Models; use Main_Models;

with Message_Boxes; use Message_Boxes;

with Gtk.Button; use Gtk.Button;
with Gtk.Label; use Gtk.Label;
with Gtkada.File_Selection; use Gtkada.File_Selection;

with GNAT.Os_Lib; use GNAT.OS_Lib;

--  Controller for positions table display
package body Positions_Controllers is

   ----------------------
   --  Initialization  --
   ----------------------

   procedure Initialize
     (C : access Positions_Controller;
      M : access Model_Obj'Class;
      V : access View_Obj'Class)
   is
   begin
      --  Call super initialization operation
      Initialize (Controller_Obj (C.all)'Access, M, V);

      C.Dialog := Dialog (View_Role (V.all)'Access);
   end Initialize;


   ------------------------
   --  Basic Operations  --
   ------------------------

   --  Close positions dialog for this event
   procedure Close_Dialog (This : access Positions_Controller) is
   begin
      --  First disable updates of the view
      Disable (View_Role (View (This).all)'Access);
      Hide_All (This.Dialog);
   end Close_Dialog;


   --  Export positions to a file
   procedure Export_Positions (This : access Positions_Controller) is
      Event : Event_Model_Ptr :=
        Event_Model (Model (This).all)'Access;

      Spec : String :=
        File_Selection_Dialog
        (Title => "Save Positions for " &
           Description (Event) &
           " to File",
         Default_Dir =>
           Event_Directory
           (Main_Model (Event_Models.Main (Event).all)'access));
   begin
      if Spec = "" or else
        Spec (Spec'Last) = GNAT.Os_Lib.Directory_Separator then
         Invalid_Input_Box
           ("Positions not exported: invalid file specification");
      else
         --  Export current positions to file "Spec"
         Update_All (Event_Model (Model (This).all)'Access,
                     New_Export_Event (Spec),
                     Suppress_Main_Update => True);
      end if;
   end Export_Positions;


   --  Toggle whether updates are received by the view
   procedure Toggle_Frozen (This : access Positions_Controller) is
   begin
      if Get
        (Gtk_Label
         (Get_Child (This.Dialog.Toggle_Updates_Button)))
        = "Freeze" then
         --  Change dialog to frozen state
         Disable (View_Role (View (This).all)'Access);
         Set_Text
           (Gtk_Label
            (Get_Child (This.Dialog.Toggle_Updates_Button)),
            "Thaw");
      else
         --  Change dialog to thawed state & and catch up to model
         Enable (View_Role (View (This).all)'Access);
         Set_Text
           (Gtk_Label
            (Get_Child (This.Dialog.Toggle_Updates_Button)),
            "Freeze");
         Update_All (Event_Model (Model (This).all)'Access,
                     new Event_Models.Update_Event,
                     Suppress_Main_Update => True);
      end if;
   end Toggle_Frozen;

end Positions_Controllers;
