------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                 --
--                                                                          --
--                           POSITIONS_CONTROLLERS                          --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.3 $                             --
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with MVC; use MVC;

with Positions_Dialog_Pkg; use Positions_Dialog_Pkg;

--  Controller for positions table display
package Positions_Controllers is

   type Positions_Controller is new Controller_Obj with private;
   type Positions_Controller_Ptr is access all Positions_Controller'Class;


   ----------------------
   --  Initialization  --
   ----------------------

   --  Set up controller
   procedure Initialize
     (C : access Positions_Controller;
      M : access Model_Obj'Class;
      V : access View_Obj'Class);


   ---------------
   --  Queries  --
   ---------------



   ------------------------
   --  Basic Operations  --
   ------------------------

   --  Close positions dialog
   procedure Close_Dialog (This : access Positions_Controller);

   --  Export positions to a file
   procedure Export_Positions (This : access Positions_Controller);

   --  Toggle frozen state.  When frozen, data updates are ignored
   procedure Toggle_Frozen (This : access Positions_Controller);

private
   type Positions_Controller is new Controller_Obj with record
      Dialog : Positions_Dialog_Access;
   end record;

   pragma Inline (Close_Dialog);

end Positions_Controllers;
