------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                             POSITIONS_VIEWS                              --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.3 $
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with Publish_Subscribe; use Publish_Subscribe;
with MVC; use MVC;

with Positions_Dialog_Pkg; use Positions_Dialog_Pkg;
with Positions_Controllers; use Positions_Controllers;
with Event_Models; use Event_Models;

with Reporters; use Reporters;

--  View for table of positions display
package Positions_Views is

   --  This object is both a view on an event model, and a model for its
   --  sub-views, allowing chained updates.  This is implemented by
   --  inheriting from both "Model" and "View" defined in package "MVC".
   --  The positions table dialog comprises a set of GTK+ Clists, one for
   --  each coordinate system of interest, and one for row labels for
   --  bodies selected for display
   type Positions_View is new Model_Obj with private;
   type Positions_Views_Ptr is access all Positions_View'Class;

   --  Event for relaying update info to position reporters for various
   --  coordinate systems
   type Report_Event is new Event with record
      Source : Event_Model_Ptr;
      Evt : Update_Event_Ptr;
   end record;

   type Report_Event_Ptr is access all Report_Event'Class;

   ----------------------
   --  Initialization  --
   ----------------------

   --  Set up view and controller
   procedure Initialize
     (This : access Positions_View; M : access Model_Obj'Class);


   ---------------
   --  Queries  --
   ---------------

   --  Reference to the positions table dialog from full view
   function Dialog (This : access Positions_View)
                   return Positions_Dialog_Access;

   --  The part of "Positions_View" that implements its view role
   type View_Role (Full_View : access Positions_View) is
     new View_Obj with private;

   --  Reference to positions table dialog from view role
   function Dialog (This : access View_Role)
                   return Positions_Dialog_Access;


   ----------------------
   --  Status Setting  --
   ----------------------

   --  Disable updates
   procedure Disable (This : access View_Role);

   --  Enable updates
   procedure Enable (This : access View_Role);


private

   --  Update operation
   procedure Update
     (This : access View_Role;
      Source : access Observable'Class;
      Evt : access Event'Class);

   type Positions_View is new Model_Obj with record
      --  "View" role (multiple inheritance)
      Viewer : aliased View_Role (Positions_View'Access);
      Controller : Positions_Controller_Ptr;
      Dialog  : Positions_Dialog_Access;

      --  Table components
      Header : Reporter_Ptr;
      Ecliptic : Reporter_Ptr;
      Equator : Reporter_Ptr;
      Terra : Reporter_Ptr;

      --  Accepting updates?
      Updatable : Boolean := False;

      --  A selected view kind?
      Selected : Boolean := True;
   end record;

   type View_Role (Full_View : access Positions_View) is
     new View_Obj with null record;

   pragma Inline (Dialog);
   pragma Inline (Disable, Enable);

end Positions_Views;
