------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                          PRIMARIES_CONTROLLERS                           --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.4 $
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with MVC; use MVC;

with Primaries_Dialog_Pkg; use Primaries_Dialog_Pkg;

--  Controller for primary directions list dialog
package Primaries_Controllers is

   type Primaries_Controller is new Controller_Obj with private;
   type Primaries_Controller_Ptr is access all Primaries_Controller'Class;

   ----------------------
   --  Initialization  --
   ----------------------

   --  Set up controller for event specification
   procedure Initialize
     (C : access Primaries_Controller;
      M : access Model_Obj'Class;
      V : access View_Obj'Class);

   ------------------------
   --  Basic Operations  --
   ------------------------

   --  Generate and display the primaries direction list
   procedure Calculate (This : access Primaries_Controller);

   --  Update primaries list if already displayed
   procedure Conditional_Update (This : access Primaries_Controller);

   --  Close the primary directions list dialog
   procedure Close (This : access Primaries_Controller);

   --  Export list of directions if available
   procedure Export (This : access Primaries_Controller);

   --  Open filtering dialog
   procedure Open_Filter (This : access Primaries_Controller);

private
   type Primaries_Controller is new Controller_Obj with record
      Dialog : Primaries_Dialog_Access;
   end record;

   pragma Inline (Close, Conditional_Update, Open_Filter);

end Primaries_Controllers;
