------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                             PRIMARIES_VIEWS                              --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.4 $
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with Ada.Strings.Unbounded; use Ada.Strings.Unbounded;

with Publish_Subscribe; use Publish_Subscribe;
with MVC; use MVC;
with Times; use Times;

with Filter_Primaries_Views; use Filter_Primaries_Views;
with Primaries_Dialog_Pkg; use Primaries_Dialog_Pkg;
with Primaries_Controllers; use Primaries_Controllers;

--  View for primary directions list dialog.  Model is an event.
package Primaries_Views is

   type Primaries_View is new View_Obj with private;
   type Primaries_View_Ptr is access all Primaries_View'Class;

   --  Description of a direction
   type Direction is record
      Date : Julian_Day;
      Description : Unbounded_String;
   end record;

   --  Array of directions. First index must be 0, and directions
   --  must be in positions 1 .. N, as this is required by
   --  GNAT.Hsort_A
   type Directions_Array is array (Natural range <>) of Direction;

   ----------------------
   --  Initialization  --
   ----------------------

   --  Set up view and controller
   procedure Initialize
     (This : access Primaries_View; M : access Model_Obj'Class);


   ---------------
   --  Queries  --
   ---------------

   --  Reference to the dialog
   function Dialog (This : access Primaries_View)
                   return Primaries_Dialog_Access;

   --  Reference to the filtering dialog
   function Filter (This : access Primaries_View)
                   return Filter_Primaries_View_Ptr;


   ------------------------
   --  Basic Operations  --
   ------------------------

   --  Close the primary directions list dialog
   procedure Close (This : access Primaries_View);

private

   --  Update operation
   procedure Update
     (This : access Primaries_View;
      Source : access Observable'Class;
      Evt : access Event'Class);

   type Primaries_View is new View_Obj with record
      Controller : Primaries_Controller_Ptr;
      Dialog  : Primaries_Dialog_Access;
      Filter : aliased Filter_Primaries_View;
      Displaying : Boolean := False;
   end record;

   --  Sorted table of strings representing directions
   type Directions_Table is
     array (Natural range <>, Natural range <>) of Unbounded_String;

   pragma Inline (Dialog, Filter);

end Primaries_Views;
