------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                             REPORTERS.EQUATOR                            --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.3 $
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with Ephemeris.Flags; use Ephemeris.Flags;
with Decimal_Sexagesimal; use Decimal_Sexagesimal;
with Body_Models; use Body_Models;
with Coordinate_Conversions; use Coordinate_Conversions;

with Positions_Dialog_Pkg; use Positions_Dialog_Pkg;
with Positions_Views; use Positions_Views;

--  View for GTK+ columned list display of equatorial coordinates
package body Reporters.Equator is

     ----------------------
     --  Initialization  --
     ----------------------

   --  Establish reference to model (Positions_View)
   procedure Initialize
     (This : access Reporter; M : access Model_Obj'Class) is

      Positions_Dialog : Positions_Dialog_Access :=
        Dialog (Positions_View (M.all)'Access);
   begin
      --  Super version of operation
      MVC.Initialize (View_Obj (This.all)'Access, M);
      Add_Observer (M, Observer (This.all)'Access);

      --  Associate with ecliptic display table
      This.Table := Positions_Dialog.Equator_Table;
      Format_Table (This);
   end Initialize;

   function Get_Coordinates
     (This : access Reporter;
      Source : access Event_Model'Class;
      Evt : access Update_Event'Class;
      Cusp : Cusps) return Coordinates is

      Coords : Coord_2D;
      Obliquity : Long_Float;
   begin
      Calculate_UT (JD_UT (Evt.all), Obliquity_And_Nutation);
      Obliquity := Longitude;

      --  Topocentric is closest to Svarogich.  We don't use
      --  intermediate cusps anyway at this point.
      Calculate_Cusps (Source, Latitude (Evt.all), Ephemeris.Topocentric);
      Coords :=
        (Long =>
           Event_Models.Cusp (Source, ((Cusps'Pos (Cusp) + 9) mod 12) + 1),
         Lat => 0.0);
      Coords := To_Equatorial (Coords, Obliquity);
      return
           (Count => 2,
            Longitude => Pad (To_Degree_String (Coords.Long), Right),
            Lat  => Pad (To_Degree_String (Coords.Lat), Right));
   end Get_Coordinates;

   -- Equatorial coordinate strings for one body
   function Get_Coordinates
     (This : access Reporter;
      Source : access Event_Model'Class;
      Evt : access Update_Event'Class;
      The_Body : Natural) return Coordinates is
   begin
      --  Calculate equatorial coordinates
      Use_Equatorial;
      Ephemeris.Set_Topocentric_Parameters
        (Longitude (Evt.all),
         Latitude (Evt.all),
         Altitude (Evt.all));
      Calculate_UT (JD_UT (Evt.all), The_Body);

      --  Format corresponding strings
      return
        (Count => 2,
         Longitude => Pad (To_Degree_String (Longitude), Right),
         Lat => Pad (To_Degree_String (Latitude), Right));
   end Get_Coordinates;

end Reporters.Equator;
