------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                             REPORTERS.TERRA                              --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.3 $
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with Decimal_Sexagesimal;
use Decimal_Sexagesimal;
with Reporters.Terra.Calculations;
use Reporters.Terra.Calculations;

with Positions_Dialog_Pkg; use Positions_Dialog_Pkg;
with Positions_Views; use Positions_Views;

--  View for GTK+ columned list display of terrestrial longitude
package body Reporters.Terra is

     ----------------------
     --  Initialization  --
     ----------------------

   --  Establish reference to model
   procedure Initialize
     (This : access Reporter; M : access Model_Obj'Class) is

      Positions_Dialog : Positions_Dialog_Access :=
        Dialog (Positions_View (M.all)'Access);
   begin
      --  Super version of operation
      MVC.Initialize (View_Obj (This.all)'Access, M);
      Add_Observer (M, Observer (This.all)'Access);

      --  Associate with terrestrial longitude display table
      This.Table := Positions_Dialog.Terra_List;
      Format_Table (This);
   end Initialize;


   --  Terrestrial longitude string for one cusp
   function Get_Coordinates
     (This : access Reporter;
      Source : access Event_Model'Class;
      Evt : access Update_Event'Class;
      Cusp : Cusps) return Coordinates is
   begin
      return
        (Count => 1,
         Longitude =>
           Pad (To_Degree_String
                (Long_Float ((Cusps'Pos (Cusp) * 30 + 270) mod 360)),
                 Right));
   end Get_Coordinates;

   -- Terrestrial longitude string for one body
   function Get_Coordinates
     (This : access Reporter;
      Source : access Event_Model'Class;
      Evt : access Update_Event'Class;
      The_Body : Natural) return Coordinates is
   begin
      return
        (Count => 1,
         Longitude =>
           Pad (To_Degree_String
                (House_Position
                 (Update_Event_Ptr (Evt), The_Body)), Right));
         end Get_Coordinates;

end Reporters.Terra;
