------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                             ASPECT_SELECTOR                              --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.3 $
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with Gtk.Enums; use Gtk.Enums;
with Glib; use Glib;
with Callbacks_Astroframes; use Callbacks_Astroframes;
with Astroframes_Intl; use Astroframes_Intl;
with Aspect_Selector.Callbacks;
use Aspect_Selector.Callbacks;
with Ada.Strings.Fixed, Ada.Strings.Maps.Constants;
use Ada.Strings, Ada.Strings.Fixed, Ada.Strings.Maps.Constants;

--  Aspect selector widget
package body Aspect_Selector is

   function Format (S : String) return String;

   procedure Gtk_New (Aspect_Selector : out Aspect_Selectors_Access) is
   begin
      Aspect_Selector := new Aspect_Selectors;
      Initialize (Gtk_Table (Aspect_Selector), 5, 2, True);
   end Gtk_New;

   procedure Initialize
     (Aspect_Selector : access Aspect_Selectors'Class;
      Controller : Controller_Ptr) is
      Pos : Guint;
   begin
      Set_Row_Spacings (Aspect_Selector, 0);
      Set_Col_Spacings (Aspect_Selector, 0);

      for I in Aspect_Selector.Check_Buttons'Range loop
         Pos := Selector_Aspect'Pos (I) -
           Selector_Aspect'Pos (Selector_Aspect'First);
         Gtk_New (Aspect_Selector.Check_Buttons (I),
                  - Format (Selector_Aspect'Image (I)));
         Attach (Aspect_Selector,
                 Aspect_Selector.Check_Buttons (I),
                 Pos / 5,
                 Pos / 5 + 1,
                 Pos mod 5,
                 Pos mod 5 + 1,
                 Fill or Expand, 0, 0, 0);
         Indexed_Check_Button_Callback.Connect
           (Aspect_Selector.Check_Buttons (I), "toggled",
            Indexed_Check_Button_Callback.To_Marshaller
            (On_Aspect_Toggled'Access),
            (Controller, I));
      end loop;
   end Initialize;

   function Format (S : String) return String is
      Result : String := S;
      Underscore : Natural;
   begin
      --  Change casing to capitalized
      Translate (Result (2 .. Result'Length), Lower_Case_Map);

      --  Replace underscore with hyphen
      Underscore := Index (Result, "_");
      if Underscore /= 0 then
         Overwrite (Result, Underscore, "-");
      end if;
      return Result;
   end Format;

end Aspect_Selector;
