------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                             ASPECT_SELECTOR                              --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.3 $
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------
with Gtk.Table; use Gtk.Table;
with Gtk.Check_Button; use Gtk.Check_Button;

with MVC; use MVC;
with Aspect_Selections; use Aspect_Selections;
--  Aspect selector widget
package Aspect_Selector is

   type Indexed_Aspect_Data is record
      Controller : Controller_Ptr;
      Index : Selector_Aspect;
   end record;

   type Selector_Array is array (Selector_Aspect) of Gtk_Check_Button;

   type Aspect_Selectors is new Gtk_Table_Record with record
      Check_Buttons : Selector_Array;
   end record;

   type Aspect_Selectors_Access is access all Aspect_Selectors'Class;

   procedure Gtk_New (Aspect_Selector : out Aspect_Selectors_Access);

   procedure Initialize
     (Aspect_Selector : access Aspect_Selectors'Class;
      Controller : Controller_Ptr);

end Aspect_Selector;
