------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                         BODY_DIALOG_PKG.CALLBACKS                        --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.3 $
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------


with Gtk.Widget; use Gtk.Widget;
with Body_Controllers; use Body_Controllers;

--  Callbacks for bodies selection dialog.  Stubs auto-generated by glade
package body Body_Dialog_Pkg.Callbacks is

   use Gtk.Arguments;

   ---------------------------------
   -- On_Body_Dialog_Delete_Event --
   ---------------------------------

   --  Discard changes and close dialog
   function On_Body_Dialog_Delete_Event
     (Object : access Gtk_Widget_Record'Class;
      Params : Gtk.Arguments.Gtk_Args;
      Controller : Controller_Ptr) return Boolean
   is
   begin
      Delete_Dialog (Body_Controller (Controller.all)'Access);
      return True;
   end On_Body_Dialog_Delete_Event;

   --------------------------
   -- On_Ok_Button_Clicked --
   --------------------------

   --  Commit changes, update positions and close dialog
   procedure On_Ok_Button_Clicked
     (Object : access Gtk_Button_Record'Class;
      Controller : Controller_Ptr)
   is
   begin
      Body_Controllers.Update_All (Body_Controller (Controller.all)'Access);
      Undisplay (Body_Controller (Controller.all)'Access);
   end On_Ok_Button_Clicked;

   -----------------------------
   -- On_Apply_Button_Clicked --
   -----------------------------

   --  Commit changes, update positions and leave dialog open
   procedure On_Apply_Button_Clicked
     (Object : access Gtk_Button_Record'Class;
      Controller : Controller_Ptr)
   is
   begin
      Body_Controllers.Update_All (Body_Controller (Controller.all)'Access);
   end On_Apply_Button_Clicked;

   ------------------------------
   -- On_Cancel_Button_Clicked --
   ------------------------------

   --  Discard changes, close dialog
   procedure On_Cancel_Button_Clicked
     (Object : access Gtk_Button_Record'Class;
      Controller : Controller_Ptr)
   is
   begin
      Undisplay (Body_Controller (Controller.all)'Access);
      Reset_Dialog_State (Body_Controller (Controller.all)'Access);
   end On_Cancel_Button_Clicked;

end Body_Dialog_Pkg.Callbacks;
