------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                              BODY_SELECTOR                               --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.3 $
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with Gtk; use Gtk;
with Gtk.Enums;       use Gtk.Enums;

with Callbacks_Astroframes; use Callbacks_Astroframes;
with Astroframes_Intl; use Astroframes_Intl;
with Body_Selector.Callbacks; use Body_Selector.Callbacks;

--  Body selector composite widget
package body Body_Selector is

   procedure Gtk_New (Body_Selector : out Body_Selectors_Access) is
   begin
      Body_Selector := new Body_Selectors;
   end Gtk_New;

   procedure Initialize
     (Body_Selector : access Body_Selectors'Class;
      Controller : Controller_Ptr) is
   begin
      Gtk.Box.Initialize_Hbox (Body_Selector);

      Gtk_New (Body_Selector.Body_Table, 9, 2, True);
      Set_Border_Width (Body_Selector.Body_Table, 3);
      Set_Row_Spacings (Body_Selector.Body_Table, 0);
      Set_Col_Spacings (Body_Selector.Body_Table, 0);
      Pack_Start (Body_Selector, Body_Selector.Body_Table, False, True, 0);

      Gtk_New (Body_Selector.Checkbutton16, -"Sun");
      Set_Active (Body_Selector.Checkbutton16, True);
      Attach (Body_Selector.Body_Table, Body_Selector.Checkbutton16,
              0, 1, 0, 1,
              Fill, 0,
              0, 0);
      Check_Button_Callback.Connect
        (Body_Selector.Checkbutton16, "toggled",
         Check_Button_Callback.To_Marshaller (On_Body_Toggled'Access),
         Controller);
      Set_Active (Body_Selector.Checkbutton16, True);

      Gtk_New (Body_Selector.Checkbutton17, -"Moon");
      Set_Active (Body_Selector.Checkbutton17, True);
      Attach (Body_Selector.Body_Table, Body_Selector.Checkbutton17,
              0, 1, 1, 2,
              Fill, 0,
              0, 0);
      Check_Button_Callback.Connect
        (Body_Selector.Checkbutton17, "toggled",
         Check_Button_Callback.To_Marshaller (On_Body_Toggled'Access),
         Controller);
      Set_Active (Body_Selector.Checkbutton17, True);

      Gtk_New (Body_Selector.Checkbutton18, -"Mercury");
      Set_Active (Body_Selector.Checkbutton18, True);
      Attach (Body_Selector.Body_Table, Body_Selector.Checkbutton18,
              0, 1, 2, 3,
              Fill, 0,
              0, 0);
      Check_Button_Callback.Connect
        (Body_Selector.Checkbutton18, "toggled",
         Check_Button_Callback.To_Marshaller (On_Body_Toggled'Access),
         Controller);
      Set_Active (Body_Selector.Checkbutton18, True);

      Gtk_New (Body_Selector.Checkbutton19, -"Venus");
      Set_Active (Body_Selector.Checkbutton19, True);
      Attach (Body_Selector.Body_Table, Body_Selector.Checkbutton19,
              0, 1, 3, 4,
              Fill, 0,
              0, 0);
      Check_Button_Callback.Connect
        (Body_Selector.Checkbutton19, "toggled",
         Check_Button_Callback.To_Marshaller (On_Body_Toggled'Access),
         Controller);
      Set_Active (Body_Selector.Checkbutton19, True);

      Gtk_New (Body_Selector.Checkbutton20, -"Mars");
      Set_Active (Body_Selector.Checkbutton20, True);
      Attach (Body_Selector.Body_Table, Body_Selector.Checkbutton20,
              0, 1, 4, 5,
              Fill, 0,
              0, 0);
      Check_Button_Callback.Connect
        (Body_Selector.Checkbutton20, "toggled",
         Check_Button_Callback.To_Marshaller (On_Body_Toggled'Access),
         Controller);
      Set_Active (Body_Selector.Checkbutton20, True);

      Gtk_New (Body_Selector.Checkbutton21, -"Jupiter");
      Set_Active (Body_Selector.Checkbutton21, True);
      Attach (Body_Selector.Body_Table, Body_Selector.Checkbutton21,
              0, 1, 5, 6,
              Fill, 0,
              0, 0);
      Check_Button_Callback.Connect
        (Body_Selector.Checkbutton21, "toggled",
         Check_Button_Callback.To_Marshaller (On_Body_Toggled'Access),
         Controller);
      Set_Active (Body_Selector.Checkbutton21, True);

      Gtk_New (Body_Selector.Checkbutton22, -"Saturn");
      Set_Active (Body_Selector.Checkbutton22, True);
      Attach (Body_Selector.Body_Table, Body_Selector.Checkbutton22,
              0, 1, 6, 7,
              Fill, 0,
              0, 0);
      Check_Button_Callback.Connect
        (Body_Selector.Checkbutton22, "toggled",
         Check_Button_Callback.To_Marshaller (On_Body_Toggled'Access),
         Controller);
      Set_Active (Body_Selector.Checkbutton22, True);

      Gtk_New (Body_Selector.Checkbutton23, -"Uranus");
      Set_Active (Body_Selector.Checkbutton23, True);
      Attach (Body_Selector.Body_Table, Body_Selector.Checkbutton23,
              0, 1, 7, 8,
              Fill, 0,
              0, 0);
      Check_Button_Callback.Connect
        (Body_Selector.Checkbutton23, "toggled",
         Check_Button_Callback.To_Marshaller (On_Body_Toggled'Access),
         Controller);
      Set_Active (Body_Selector.Checkbutton23, True);

      Gtk_New (Body_Selector.Checkbutton24, -"Neptune");
      Set_Active (Body_Selector.Checkbutton24, True);
      Attach (Body_Selector.Body_Table, Body_Selector.Checkbutton24,
              0, 1, 8, 9,
              Fill, 0,
              0, 0);
      Check_Button_Callback.Connect
        (Body_Selector.Checkbutton24, "toggled",
         Check_Button_Callback.To_Marshaller (On_Body_Toggled'Access),
         Controller);
      Set_Active (Body_Selector.Checkbutton24, True);

      Gtk_New (Body_Selector.Checkbutton25, -"Pluto");
      Set_Active (Body_Selector.Checkbutton25, True);
      Attach (Body_Selector.Body_Table, Body_Selector.Checkbutton25,
              1, 2, 0, 1,
              Fill, 0,
              0, 0);
      Check_Button_Callback.Connect
        (Body_Selector.Checkbutton25, "toggled",
         Check_Button_Callback.To_Marshaller (On_Body_Toggled'Access),
         Controller);
      Set_Active (Body_Selector.Checkbutton25, True);

      Gtk_New (Body_Selector.Checkbutton26, -"Chiron");
      Set_Active (Body_Selector.Checkbutton26, True);
      Attach (Body_Selector.Body_Table, Body_Selector.Checkbutton26,
              1, 2, 1, 2,
              Fill, 0,
              0, 0);
      Check_Button_Callback.Connect
        (Body_Selector.Checkbutton26, "toggled",
         Check_Button_Callback.To_Marshaller (On_Body_Toggled'Access),
         Controller);
      Set_Active (Body_Selector.Checkbutton26, True);


      Gtk_New (Body_Selector.Checkbutton27, -"Mean Node");
      Set_Active (Body_Selector.Checkbutton27, True);
      Attach (Body_Selector.Body_Table, Body_Selector.Checkbutton27,
              1, 2, 7, 8,
              Fill, 0,
              0, 0);
      Check_Button_Callback.Connect
        (Body_Selector.Checkbutton27, "toggled",
         Check_Button_Callback.To_Marshaller (On_Body_Toggled'Access),
         Controller);
      Set_Active (Body_Selector.Checkbutton27, True);


      Gtk_New (Body_Selector.Checkbutton28, -"Pholus");
      Set_Active (Body_Selector.Checkbutton28, False);
      Attach (Body_Selector.Body_Table, Body_Selector.Checkbutton28,
              1, 2, 2, 3,
              Fill, 0,
              0, 0);
      Check_Button_Callback.Connect
        (Body_Selector.Checkbutton28, "toggled",
         Check_Button_Callback.To_Marshaller (On_Body_Toggled'Access),
         Controller);
      Set_Active (Body_Selector.Checkbutton28, False);


      Gtk_New (Body_Selector.Checkbutton29, -"Ceres");
      Set_Active (Body_Selector.Checkbutton29, False);
      Attach (Body_Selector.Body_Table, Body_Selector.Checkbutton29,
              1, 2, 3, 4,
              Fill, 0,
              0, 0);
      Check_Button_Callback.Connect
        (Body_Selector.Checkbutton29, "toggled",
         Check_Button_Callback.To_Marshaller (On_Body_Toggled'Access),
         Controller);
      Set_Active (Body_Selector.Checkbutton29, False);


      Gtk_New (Body_Selector.Checkbutton30, -"Pallas");
      Set_Active (Body_Selector.Checkbutton30, False);
      Attach (Body_Selector.Body_Table, Body_Selector.Checkbutton30,
              1, 2, 4, 5,
              Fill, 0,
              0, 0);
      Check_Button_Callback.Connect
        (Body_Selector.Checkbutton30, "toggled",
         Check_Button_Callback.To_Marshaller (On_Body_Toggled'Access),
         Controller);
      Set_Active (Body_Selector.Checkbutton30, False);


      Gtk_New (Body_Selector.Checkbutton31, -"Juno");
      Set_Active (Body_Selector.Checkbutton31, False);
      Attach (Body_Selector.Body_Table, Body_Selector.Checkbutton31,
              1, 2, 5, 6,
              Fill, 0,
              0, 0);
      Check_Button_Callback.Connect
        (Body_Selector.Checkbutton31, "toggled",
         Check_Button_Callback.To_Marshaller (On_Body_Toggled'Access),
         Controller);
      Set_Active (Body_Selector.Checkbutton31, False);


      Gtk_New (Body_Selector.Checkbutton32, -"Vesta");
      Set_Active (Body_Selector.Checkbutton32, False);
      Attach (Body_Selector.Body_Table, Body_Selector.Checkbutton32,
              1, 2, 6, 7,
              Fill, 0,
              0, 0);
      Check_Button_Callback.Connect
        (Body_Selector.Checkbutton32, "toggled",
         Check_Button_Callback.To_Marshaller (On_Body_Toggled'Access),
         Controller);
      Set_Active (Body_Selector.Checkbutton32, False);


      Gtk_New (Body_Selector.Checkbutton33, -"True Node");
      Set_Active (Body_Selector.Checkbutton33, False);
      Attach (Body_Selector.Body_Table, Body_Selector.Checkbutton33,
              1, 2, 8, 9,
              Fill, 0,
              0, 0);
      Check_Button_Callback.Connect
        (Body_Selector.Checkbutton33, "toggled",
         Check_Button_Callback.To_Marshaller (On_Body_Toggled'Access),
         Controller);
      Set_Active (Body_Selector.Checkbutton33, False);


      Gtk_New_Vseparator (Body_Selector.Vseparator1);
      Pack_Start (Body_Selector, Body_Selector.Vseparator1, False, False, 0);

      Gtk_New_Vbox (Body_Selector.Vbox10, False, 0);
      Set_Border_Width (Body_Selector.Vbox10, 3);
      Pack_Start (Body_Selector, Body_Selector.Vbox10, False, True, 0);

      Gtk_New (Body_Selector.Label52, -("Enter Body by Catalog #"));
      Set_Alignment (Body_Selector.Label52, 0.5, 0.5);
      Set_Padding (Body_Selector.Label52, 0, 0);
      Set_Justify (Body_Selector.Label52, Justify_Center);
      Set_Line_Wrap (Body_Selector.Label52, False);
      Pack_Start (Body_Selector.Vbox10, Body_Selector.Label52,
                  False, False, 0);

      Gtk_New (Body_Selector.Extended_Entry);
      Entry_Callback.Connect
        (Body_Selector.Extended_Entry, "activate",
         Entry_Callback.To_Marshaller (On_Extended_Entry_Activate'Access),
         Controller);

      Set_Editable (Body_Selector.Extended_Entry, True);
      Set_Max_Length (Body_Selector.Extended_Entry, 5);
      Set_Text (Body_Selector.Extended_Entry, -"1");
      Set_Visibility (Body_Selector.Extended_Entry, True);
      Pack_Start (Body_Selector.Vbox10, Body_Selector.Extended_Entry,
                  False, False, 0);

      Gtk_New (Body_Selector.Scrolledwindow7);
      Set_Policy (Body_Selector.Scrolledwindow7,
                  Policy_Automatic, Policy_Automatic);
      Pack_Start (Body_Selector.Vbox10, Body_Selector.Scrolledwindow7,
                  True, True, 0);

      Gtk_New (Body_Selector.Extended_List, 1);
      Set_Selection_Mode (Body_Selector.Extended_List, Selection_Multiple);
      Set_Shadow_Type (Body_Selector.Extended_List, Shadow_In);
      Set_Show_Titles (Body_Selector.Extended_List, True);
      Set_Column_Width (Body_Selector.Extended_List, 0, 80);
      Add (Body_Selector.Scrolledwindow7, Body_Selector.Extended_List);

      Gtk_New (Body_Selector.Label53, -("Cataloged Bodies"));
      Set_Alignment (Body_Selector.Label53, 0.5, 0.5);
      Set_Padding (Body_Selector.Label53, 0, 0);
      Set_Justify (Body_Selector.Label53, Justify_Center);
      Set_Line_Wrap (Body_Selector.Label53, False);
      Set_Column_Widget (Body_Selector.Extended_List, 0,
                         Body_Selector.Label53);

      Gtk_New (Body_Selector.Delete_Button, -"Delete Selected Body");
      Set_Relief (Body_Selector.Delete_Button, Relief_Normal);
      Pack_Start (Body_Selector.Vbox10, Body_Selector.Delete_Button,
                  False, False, 0);
      Button_Callback.Connect
        (Body_Selector.Delete_Button, "clicked",
         Button_Callback.To_Marshaller (On_Delete_Button_Clicked'Access),
         Controller);

      Gtk_New (Body_Selector.Clear_Button, -"Clear Cataloged Bodies");
      Set_Relief (Body_Selector.Clear_Button, Relief_Normal);
      Pack_Start (Body_Selector.Vbox10, Body_Selector.Clear_Button,
                  False, False, 0);
      Button_Callback.Connect
        (Body_Selector.Clear_Button, "clicked",
         Button_Callback.To_Marshaller (On_Clear_Button_Clicked'Access),
         Controller);
   end Initialize;

end Body_Selector;
