------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                             EVENT_DIALOG_PKG                             --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.3 $
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with Gtk; use Gtk;
with Glib; use Glib;
with Gtk.Widget;      use Gtk.Widget;
with Gtk.Enums;       use Gtk.Enums;
with Callbacks_Astroframes; use Callbacks_Astroframes;
with Astroframes_Intl; use Astroframes_Intl;
with Event_Dialog_Pkg.Callbacks; use Event_Dialog_Pkg.Callbacks;

--  Event definition dialog
package body Event_Dialog_Pkg is

procedure Gtk_New (Event_Dialog : out Event_Dialog_Access) is
begin
   Event_Dialog := new Event_Dialog_Record;
end Gtk_New;

procedure Initialize
  (Event_Dialog : access Event_Dialog_Record'Class;
   Controller : Controller_Ptr) is
   pragma Suppress (All_Checks);
   Month_Entry_Items : String_List.Glist;
   Combo17_Items : String_List.Glist;
   Combo13_Items : String_List.Glist;
   Combo12_Items : String_List.Glist;

begin
   Gtk.Dialog.Initialize (Event_Dialog);
   Set_Title (Event_Dialog, -"AstroFrames:  Event Description");
   Set_Policy (Event_Dialog, True, True, False);
   Set_Position (Event_Dialog, Win_Pos_Center);
   Set_Modal (Event_Dialog, False);

   Event_Dialog.Dialog_Vbox5 := Get_Vbox (Event_Dialog);
   Set_Homogeneous (Event_Dialog.Dialog_Vbox5, False);
   Set_Spacing (Event_Dialog.Dialog_Vbox5, 0);

   Event_Dialog.Dialog_Action_Area5 := Get_Action_Area (Event_Dialog);
   Set_Border_Width (Event_Dialog.Dialog_Action_Area5, 10);
   Set_Homogeneous (Event_Dialog.Dialog_Action_Area5, True);
   Set_Spacing (Event_Dialog.Dialog_Action_Area5, 5);

   Gtk_New (Event_Dialog.Hbuttonbox1);
   Set_Spacing (Event_Dialog.Hbuttonbox1, 30);
   Set_Layout (Event_Dialog.Hbuttonbox1, Buttonbox_Default_Style);
   Set_Child_Size (Event_Dialog.Hbuttonbox1, 85, 27);
   Set_Child_Ipadding (Event_Dialog.Hbuttonbox1, 7, 0);
   Pack_Start (Event_Dialog.Dialog_Action_Area5, Event_Dialog.Hbuttonbox1, False, False, 0);

   Gtk_New (Event_Dialog.Apply_Button, -"Apply");
   Set_Relief (Event_Dialog.Apply_Button, Relief_Normal);
   Set_Flags (Event_Dialog.Apply_Button, Can_Default);
   Button_Callback.Connect
     (Event_Dialog.Apply_Button, "clicked",
      Button_Callback.To_Marshaller (On_Apply_Button_Clicked'Access),
      Controller);
   Add (Event_Dialog.Hbuttonbox1, Event_Dialog.Apply_Button);

   Gtk_New (Event_Dialog.Close_Button, -"Close");
   Set_Relief (Event_Dialog.Close_Button, Relief_Normal);
   Set_Flags (Event_Dialog.Close_Button, Can_Default);
   Button_Callback.Connect
     (Event_Dialog.Close_Button, "clicked",
      Button_Callback.To_Marshaller (On_Close_Button_Clicked'Access),
      Controller);
   Add (Event_Dialog.Hbuttonbox1, Event_Dialog.Close_Button);

   Gtk_New (Event_Dialog.Notes_Button, -"Notes");
   Set_Relief (Event_Dialog.Notes_Button, Relief_Normal);
   Set_Flags (Event_Dialog.Notes_Button, Can_Default);
   Button_Callback.Connect
     (Event_Dialog.Notes_Button, "clicked",
      Button_Callback.To_Marshaller (On_Notes_Button_Clicked'Access),
      Controller);
   Add (Event_Dialog.Hbuttonbox1, Event_Dialog.Notes_Button);

   Gtk_New (Event_Dialog.Menubar2);
   Set_Shadow_Type (Event_Dialog.Menubar2, Shadow_Out);
   Pack_Start (Event_Dialog.Dialog_Vbox5, Event_Dialog.Menubar2, False, False, 0);

   Gtk_New (Event_Dialog.File_Event, -"File");
   Set_Right_Justify (Event_Dialog.File_Event, False);
   Add (Event_Dialog.Menubar2, Event_Dialog.File_Event);

   Gtk_New (Event_Dialog.File_Event_Menu);
   Set_Submenu (Event_Dialog.File_Event, Event_Dialog.File_Event_Menu);

   Gtk_New (Event_Dialog.Save_Event, -"Save");
   Set_Right_Justify (Event_Dialog.Save_Event, False);
   Menu_Item_Callback.Connect
     (Event_Dialog.Save_Event, "activate",
      Menu_Item_Callback.To_Marshaller (On_Save_Event_Activate'Access),
      Controller);
   Add (Event_Dialog.File_Event_Menu, Event_Dialog.Save_Event);

   Gtk_New (Event_Dialog.Save_As_Item, -"Save As");
   Set_Right_Justify (Event_Dialog.Save_As_Item, False);
   Menu_Item_Callback.Connect
     (Event_Dialog.Save_As_Item, "activate",
      Menu_Item_Callback.To_Marshaller (On_Save_As_Item_Activate'Access),
      Controller);
   Add (Event_Dialog.File_Event_Menu, Event_Dialog.Save_As_Item);

   Gtk_New (Event_Dialog.Separator1);
   Set_Right_Justify (Event_Dialog.Separator1, False);
   Add (Event_Dialog.File_Event_Menu, Event_Dialog.Separator1);

   Gtk_New (Event_Dialog.Close_Item, -"Close");
   Set_Right_Justify (Event_Dialog.Close_Item, False);
   Menu_Item_Callback.Connect
     (Event_Dialog.Close_Item, "activate",
      Menu_Item_Callback.To_Marshaller (On_Close_Item_Activate'Access),
      Controller);
   Add (Event_Dialog.File_Event_Menu, Event_Dialog.Close_Item);

   Gtk_New_Hbox (Event_Dialog.Hbox22, False, 0);
   Pack_Start (Event_Dialog.Dialog_Vbox5, Event_Dialog.Hbox22, True, False, 0);

   Gtk_New (Event_Dialog.Label54, -("Description:"));
   Set_Alignment (Event_Dialog.Label54, 0.5, 0.5);
   Set_Padding (Event_Dialog.Label54, 3, 0);
   Set_Justify (Event_Dialog.Label54, Justify_Right);
   Set_Line_Wrap (Event_Dialog.Label54, False);
   Pack_Start (Event_Dialog.Hbox22, Event_Dialog.Label54, False, False, 0);

   Gtk_New (Event_Dialog.Description_Entry);
   Set_Editable (Event_Dialog.Description_Entry, True);
   Set_Max_Length (Event_Dialog.Description_Entry, 0);
   Set_Text (Event_Dialog.Description_Entry, -"");
   Set_Visibility (Event_Dialog.Description_Entry, True);
   Set_Flags (Event_Dialog.Description_Entry, Can_Default + Can_Focus);
   Pack_Start (Event_Dialog.Hbox22, Event_Dialog.Description_Entry, True, True, 1);
   Return_Callback.Connect
     (Event_Dialog.Description_Entry, "focus_in_event",
      Select_Field'Access, Controller);
   Return_Callback.Connect
     (Event_Dialog.Description_Entry, "focus_out_event",
      Unselect_Field'Access, Controller);

   Gtk_New_Hseparator (Event_Dialog.Hseparator1);
   Pack_Start (Event_Dialog.Dialog_Vbox5, Event_Dialog.Hseparator1, False, True, 0);

   Gtk_New (Event_Dialog.Table1, 6, 5, False);
   Set_Row_Spacings (Event_Dialog.Table1, 0);
   Set_Col_Spacings (Event_Dialog.Table1, 0);
   Pack_Start (Event_Dialog.Dialog_Vbox5, Event_Dialog.Table1, False, False, 0);

   Gtk_New (Event_Dialog.Label55, -("Date:"));
   Set_Alignment (Event_Dialog.Label55, 0.5, 0.5);
   Set_Padding (Event_Dialog.Label55, 3, 0);
   Set_Justify (Event_Dialog.Label55, Justify_Center);
   Set_Line_Wrap (Event_Dialog.Label55, False);
   Attach (Event_Dialog.Table1, Event_Dialog.Label55, 0, 1, 0, 1,
     Shrink, Shrink,
     0, 0);

   Gtk_New (Event_Dialog.Label56, -("Local TIme:"));
   Set_Alignment (Event_Dialog.Label56, 0.5, 0.5);
   Set_Padding (Event_Dialog.Label56, 3, 0);
   Set_Justify (Event_Dialog.Label56, Justify_Right);
   Set_Line_Wrap (Event_Dialog.Label56, False);
   Attach (Event_Dialog.Table1, Event_Dialog.Label56, 0, 1, 1, 2,
     Shrink, Shrink,
     0, 0);

   Gtk_New (Event_Dialog.Label58, -("Altitude:"));
   Set_Alignment (Event_Dialog.Label58, 0.5, 0.5);
   Set_Padding (Event_Dialog.Label58, 3, 0);
   Set_Justify (Event_Dialog.Label58, Justify_Right);
   Set_Line_Wrap (Event_Dialog.Label58, False);
   Attach (Event_Dialog.Table1, Event_Dialog.Label58, 0, 1, 5, 6,
     0, 0,
     0, 0);

   Gtk_New (Event_Dialog.Label59, -("meters"));
   Set_Alignment (Event_Dialog.Label59, 0.1, 0.5);
   Set_Padding (Event_Dialog.Label59, 0, 0);
   Set_Justify (Event_Dialog.Label59, Justify_Left);
   Set_Line_Wrap (Event_Dialog.Label59, False);
   Attach (Event_Dialog.Table1, Event_Dialog.Label59, 2, 3, 5, 6,
     0, 0,
     0, 0);

   Gtk_New (Event_Dialog.Label57, -("Long:"));
   Set_Alignment (Event_Dialog.Label57, 0.5, 0.5);
   Set_Padding (Event_Dialog.Label57, 3, 0);
   Set_Justify (Event_Dialog.Label57, Justify_Right);
   Set_Line_Wrap (Event_Dialog.Label57, False);
   Attach (Event_Dialog.Table1, Event_Dialog.Label57, 0, 1, 4, 5,
     0, 0,
     0, 0);

   Gtk_New (Event_Dialog.Label60, -("Lat:"));
   Set_Alignment (Event_Dialog.Label60, 0.5, 0.5);
   Set_Padding (Event_Dialog.Label60, 3, 0);
   Set_Justify (Event_Dialog.Label60, Justify_Right);
   Set_Line_Wrap (Event_Dialog.Label60, False);
   Attach (Event_Dialog.Table1, Event_Dialog.Label60, 0, 1, 3, 4,
     0, 0,
     0, 0);

   Gtk_New (Event_Dialog.Label96, -("Zone:"));
   Set_Alignment (Event_Dialog.Label96, 0.5, 0.5);
   Set_Padding (Event_Dialog.Label96, 0, 0);
   Set_Justify (Event_Dialog.Label96, Justify_Center);
   Set_Line_Wrap (Event_Dialog.Label96, False);
   Attach (Event_Dialog.Table1, Event_Dialog.Label96, 0, 1, 2, 3,
     0, 0,
     0, 0);

   Gtk_New (Event_Dialog.Date_Day);
   Set_USize (Event_Dialog.Date_Day, 40, 22);
   Set_Editable (Event_Dialog.Date_Day, True);
   Set_Max_Length (Event_Dialog.Date_Day, 2);
   Set_Text (Event_Dialog.Date_Day, -"01");
   Set_Visibility (Event_Dialog.Date_Day, True);
   Attach (Event_Dialog.Table1, Event_Dialog.Date_Day, 1, 2, 0, 1,
     Shrink or Fill, Shrink,
     0, 0);
   Return_Callback.Connect
     (Event_Dialog.Date_Day, "focus_in_event",
      Select_Field'Access, Controller);

   Return_Callback.Connect
     (Event_Dialog.Date_Day, "focus_out_event",
      Unselect_Field'Access, Controller);

   Gtk_New (Event_Dialog.Ut_Hour);

   Set_USize (Event_Dialog.Ut_Hour, 40, 22);
   Set_Editable (Event_Dialog.Ut_Hour, True);
   Set_Max_Length (Event_Dialog.Ut_Hour, 2);
   Set_Text (Event_Dialog.Ut_Hour, -"00");
   Set_Visibility (Event_Dialog.Ut_Hour, True);
   Attach (Event_Dialog.Table1, Event_Dialog.Ut_Hour, 1, 2, 1, 2,
     Shrink or Fill, Shrink,
     0, 0);
   Return_Callback.Connect
     (Event_Dialog.Ut_Hour, "focus_in_event",
      Select_Field'Access, Controller);

   Return_Callback.Connect
     (Event_Dialog.Ut_Hour, "focus_out_event",
      Unselect_Field'Access, Controller);

   Gtk_New (Event_Dialog.Zone_Hour);
   Set_USize (Event_Dialog.Zone_Hour, 40, 22);
   Set_Editable (Event_Dialog.Zone_Hour, True);
   Set_Max_Length (Event_Dialog.Zone_Hour, 2);
   Set_Text (Event_Dialog.Zone_Hour, -"00");
   Set_Visibility (Event_Dialog.Zone_Hour, True);
   Attach (Event_Dialog.Table1, Event_Dialog.Zone_Hour, 1, 2, 2, 3,
     Expand or Fill, 0,
     0, 0);
   Return_Callback.Connect
     (Event_Dialog.Zone_Hour, "focus_in_event",
      Select_Field'Access, Controller);

   Return_Callback.Connect
     (Event_Dialog.Zone_Hour, "focus_out_event",
      Unselect_Field'Access, Controller);

   Gtk_New (Event_Dialog.Lat_Degree);
   Set_USize (Event_Dialog.Lat_Degree, 40, 22);
   Set_Editable (Event_Dialog.Lat_Degree, True);
   Set_Max_Length (Event_Dialog.Lat_Degree, 2);
   Set_Text (Event_Dialog.Lat_Degree, -"00");
   Set_Visibility (Event_Dialog.Lat_Degree, True);
   Attach (Event_Dialog.Table1, Event_Dialog.Lat_Degree, 1, 2, 3, 4,
     Expand or Fill, 0,
     0, 0);
   Return_Callback.Connect
     (Event_Dialog.Lat_Degree, "focus_in_event",
      Select_Field'Access, Controller);

   Return_Callback.Connect
     (Event_Dialog.Lat_Degree, "focus_out_event",
      Unselect_Field'Access, Controller);

   Gtk_New (Event_Dialog.Long_Degree);
   Set_USize (Event_Dialog.Long_Degree, 40, 22);
   Set_Editable (Event_Dialog.Long_Degree, True);
   Set_Max_Length (Event_Dialog.Long_Degree, 3);
   Set_Text (Event_Dialog.Long_Degree, -"00");
   Set_Visibility (Event_Dialog.Long_Degree, True);
   Attach (Event_Dialog.Table1, Event_Dialog.Long_Degree, 1, 2, 4, 5,
     Expand or Fill, 0,
     0, 0);
   Return_Callback.Connect
     (Event_Dialog.Long_Degree, "focus_in_event",
      Select_Field'Access, Controller);

   Return_Callback.Connect
     (Event_Dialog.Long_Degree, "focus_out_event",
      Unselect_Field'Access, Controller);

   Gtk_New (Event_Dialog.Alt_Entry);
   Set_USize (Event_Dialog.Alt_Entry, 40, 22);
   Set_Editable (Event_Dialog.Alt_Entry, True);
   Set_Max_Length (Event_Dialog.Alt_Entry, 5);
   Set_Text (Event_Dialog.Alt_Entry, -"00000");
   Set_Visibility (Event_Dialog.Alt_Entry, True);
   Attach (Event_Dialog.Table1, Event_Dialog.Alt_Entry, 1, 2, 5, 6,
     Expand or Fill, 0,
     0, 0);
   Return_Callback.Connect
     (Event_Dialog.Alt_Entry, "focus_in_event",
      Select_Field'Access, Controller);

   Return_Callback.Connect
     (Event_Dialog.Alt_Entry, "focus_out_event",
      Unselect_Field'Access, Controller);

   Gtk_New (Event_Dialog.Month_Entry);
   Set_Case_Sensitive (Event_Dialog.Month_Entry, False);
   Set_Use_Arrows (Event_Dialog.Month_Entry, True);
   Set_Use_Arrows_Always (Event_Dialog.Month_Entry, False);
   String_List.Append (Month_Entry_Items, -"Jan");
   String_List.Append (Month_Entry_Items, -"Feb");
   String_List.Append (Month_Entry_Items, -"Mar");
   String_List.Append (Month_Entry_Items, -"Apr");
   String_List.Append (Month_Entry_Items, -"May");
   String_List.Append (Month_Entry_Items, -"Jun");
   String_List.Append (Month_Entry_Items, -"Jul");
   String_List.Append (Month_Entry_Items, -"Aug");
   String_List.Append (Month_Entry_Items, -"Sep");
   String_List.Append (Month_Entry_Items, -"Oct");
   String_List.Append (Month_Entry_Items, -"Nov");
   String_List.Append (Month_Entry_Items, -"Dec");
   Combo.Set_Popdown_Strings (Event_Dialog.Month_Entry, Month_Entry_Items);
   Free_String_List (Month_Entry_Items);
   Attach (Event_Dialog.Table1, Event_Dialog.Month_Entry, 2, 3, 0, 1,
     Shrink or Fill, Shrink,
     0, 0);

   Event_Dialog.Date_Month := Get_Entry (Event_Dialog.Month_Entry);
   Set_USize (Event_Dialog.Date_Month, 40, 22);
   Set_Editable (Event_Dialog.Date_Month, True);
   Set_Max_Length (Event_Dialog.Date_Month, 0);
   Set_Text (Event_Dialog.Date_Month, -"Jan");
   Set_Visibility (Event_Dialog.Date_Month, True);
   Return_Callback.Connect
     (Event_Dialog.Date_Month, "focus_in_event",
      Select_Field'Access, Controller);

   Return_Callback.Connect
     (Event_Dialog.Date_Month, "focus_out_event",
      Unselect_Field'Access, Controller);

   Gtk_New (Event_Dialog.Ut_Minute);
   Set_USize (Event_Dialog.Ut_Minute, 40, 22);
   Set_Editable (Event_Dialog.Ut_Minute, True);
   Set_Max_Length (Event_Dialog.Ut_Minute, 2);
   Set_Text (Event_Dialog.Ut_Minute, -"00");
   Set_Visibility (Event_Dialog.Ut_Minute, True);
   Attach (Event_Dialog.Table1, Event_Dialog.Ut_Minute, 2, 3, 1, 2,
     Shrink or Fill, Shrink,
     0, 0);
   Return_Callback.Connect
     (Event_Dialog.Ut_Minute, "focus_in_event",
      Select_Field'Access, Controller);

   Return_Callback.Connect
     (Event_Dialog.Ut_Minute, "focus_out_event",
      Unselect_Field'Access, Controller);

   Gtk_New (Event_Dialog.Zone_Minute);
   Set_USize (Event_Dialog.Zone_Minute, 40, 22);
   Set_Editable (Event_Dialog.Zone_Minute, True);
   Set_Max_Length (Event_Dialog.Zone_Minute, 2);
   Set_Text (Event_Dialog.Zone_Minute, -"00");
   Set_Visibility (Event_Dialog.Zone_Minute, True);
   Attach (Event_Dialog.Table1, Event_Dialog.Zone_Minute, 2, 3, 2, 3,
     Shrink or Fill, Shrink,
     0, 0);
   Return_Callback.Connect
     (Event_Dialog.Zone_Minute, "focus_in_event",
      Select_Field'Access, Controller);

   Return_Callback.Connect
     (Event_Dialog.Zone_Minute, "focus_out_event",
      Unselect_Field'Access, Controller);

   Gtk_New (Event_Dialog.Lat_Minute);
   Set_USize (Event_Dialog.Lat_Minute, 40, 22);
   Set_Editable (Event_Dialog.Lat_Minute, True);
   Set_Max_Length (Event_Dialog.Lat_Minute, 2);
   Set_Text (Event_Dialog.Lat_Minute, -"00");
   Set_Visibility (Event_Dialog.Lat_Minute, True);
   Attach (Event_Dialog.Table1, Event_Dialog.Lat_Minute, 2, 3, 3, 4,
     Expand or Fill, 0,
     0, 0);
   Return_Callback.Connect
     (Event_Dialog.Lat_Minute, "focus_in_event",
      Select_Field'Access, Controller);

   Return_Callback.Connect
     (Event_Dialog.Lat_Minute, "focus_out_event",
      Unselect_Field'Access, Controller);

   Gtk_New (Event_Dialog.Long_Minute);
   Set_USize (Event_Dialog.Long_Minute, 40, 22);
   Set_Editable (Event_Dialog.Long_Minute, True);
   Set_Max_Length (Event_Dialog.Long_Minute, 2);
   Set_Text (Event_Dialog.Long_Minute, -"00");
   Set_Visibility (Event_Dialog.Long_Minute, True);
   Attach (Event_Dialog.Table1, Event_Dialog.Long_Minute, 2, 3, 4, 5,
     Expand or Fill, 0,
     0, 0);
   Return_Callback.Connect
     (Event_Dialog.Long_Minute, "focus_in_event",
      Select_Field'Access, Controller);

   Return_Callback.Connect
     (Event_Dialog.Long_Minute, "focus_out_event",
      Unselect_Field'Access, Controller);

   Gtk_New (Event_Dialog.Date_Year);
   Set_USize (Event_Dialog.Date_Year, 40, 22);
   Set_Editable (Event_Dialog.Date_Year, True);
   Set_Max_Length (Event_Dialog.Date_Year, 4);
   Set_Text (Event_Dialog.Date_Year, -"1900");
   Set_Visibility (Event_Dialog.Date_Year, True);
   Attach (Event_Dialog.Table1, Event_Dialog.Date_Year, 3, 4, 0, 1,
     Expand or Fill, 0,
     0, 0);
   Return_Callback.Connect
     (Event_Dialog.Date_Year, "focus_in_event",
      Select_Field'Access, Controller);

   Return_Callback.Connect
     (Event_Dialog.Date_Year, "focus_out_event",
      Unselect_Field'Access, Controller);

   Gtk_New (Event_Dialog.Ut_Second);
   Set_USize (Event_Dialog.Ut_Second, 40, 22);
   Set_Editable (Event_Dialog.Ut_Second, True);
   Set_Max_Length (Event_Dialog.Ut_Second, 2);
   Set_Text (Event_Dialog.Ut_Second, -"00");
   Set_Visibility (Event_Dialog.Ut_Second, True);
   Attach (Event_Dialog.Table1, Event_Dialog.Ut_Second, 3, 4, 1, 2,
     Shrink or Fill, Shrink,
     0, 0);
   Return_Callback.Connect
     (Event_Dialog.Ut_Second, "focus_in_event",
      Select_Field'Access, Controller);

   Return_Callback.Connect
     (Event_Dialog.Ut_Second, "focus_out_event",
      Unselect_Field'Access, Controller);

   Gtk_New (Event_Dialog.Combo17);
   Set_Case_Sensitive (Event_Dialog.Combo17, False);
   Set_Use_Arrows (Event_Dialog.Combo17, True);
   Set_Use_Arrows_Always (Event_Dialog.Combo17, False);
   String_List.Append (Combo17_Items, -"West");
   String_List.Append (Combo17_Items, -"East");
   Combo.Set_Popdown_Strings (Event_Dialog.Combo17, Combo17_Items);
   Free_String_List (Combo17_Items);
   Attach (Event_Dialog.Table1, Event_Dialog.Combo17, 3, 4, 2, 3,
     Expand or Fill, 0,
     0, 0);

   Event_Dialog.Zone_Direction := Get_Entry (Event_Dialog.Combo17);
   Set_USize (Event_Dialog.Zone_Direction, 40, 22);
   Set_Editable (Event_Dialog.Zone_Direction, True);
   Set_Max_Length (Event_Dialog.Zone_Direction, 0);
   Set_Text (Event_Dialog.Zone_Direction, -"West");
   Set_Visibility (Event_Dialog.Zone_Direction, True);
   Return_Callback.Connect
     (Event_Dialog.Zone_Direction, "focus_in_event",
      Select_Field'Access, Controller);

   Return_Callback.Connect
     (Event_Dialog.Zone_Direction, "focus_out_event",
      Unselect_Field'Access, Controller);

   Gtk_New (Event_Dialog.Lat_Second);
   Set_USize (Event_Dialog.Lat_Second, 40, 22);
   Set_Editable (Event_Dialog.Lat_Second, True);
   Set_Max_Length (Event_Dialog.Lat_Second, 2);
   Set_Text (Event_Dialog.Lat_Second, -"00");
   Set_Visibility (Event_Dialog.Lat_Second, True);
   Attach (Event_Dialog.Table1, Event_Dialog.Lat_Second, 3, 4, 3, 4,
     Expand or Fill, 0,
     0, 0);
   Return_Callback.Connect
     (Event_Dialog.Lat_Second, "focus_in_event",
      Select_Field'Access, Controller);

   Return_Callback.Connect
     (Event_Dialog.Lat_Second, "focus_out_event",
      Unselect_Field'Access, Controller);

   Gtk_New (Event_Dialog.Long_Second);
   Set_USize (Event_Dialog.Long_Second, 40, 22);
   Set_Editable (Event_Dialog.Long_Second, True);
   Set_Max_Length (Event_Dialog.Long_Second, 2);
   Set_Text (Event_Dialog.Long_Second, -"00");
   Set_Visibility (Event_Dialog.Long_Second, True);
   Attach (Event_Dialog.Table1, Event_Dialog.Long_Second, 3, 4, 4, 5,
     Expand or Fill, 0,
     0, 0);
   Return_Callback.Connect
     (Event_Dialog.Long_Second, "focus_in_event",
      Select_Field'Access, Controller);

   Return_Callback.Connect
     (Event_Dialog.Long_Second, "focus_out_event",
      Unselect_Field'Access, Controller);

   Gtk_New (Event_Dialog.Combo13);
   Set_Case_Sensitive (Event_Dialog.Combo13, False);
   Set_Use_Arrows (Event_Dialog.Combo13, True);
   Set_Use_Arrows_Always (Event_Dialog.Combo13, False);
   String_List.Append (Combo13_Items, -"North");
   String_List.Append (Combo13_Items, -"South");
   Combo.Set_Popdown_Strings (Event_Dialog.Combo13, Combo13_Items);
   Free_String_List (Combo13_Items);
   Attach (Event_Dialog.Table1, Event_Dialog.Combo13, 4, 5, 3, 4,
     Expand or Fill, 0,
     0, 0);

   Event_Dialog.Lat_Direction := Get_Entry (Event_Dialog.Combo13);
   Set_USize (Event_Dialog.Lat_Direction, 40, 22);
   Set_Editable (Event_Dialog.Lat_Direction, True);
   Set_Max_Length (Event_Dialog.Lat_Direction, 0);
   Set_Text (Event_Dialog.Lat_Direction, -"North");
   Set_Visibility (Event_Dialog.Lat_Direction, True);
   Return_Callback.Connect
     (Event_Dialog.Lat_Direction, "focus_in_event",
      Select_Field'Access, Controller);

   Return_Callback.Connect
     (Event_Dialog.Lat_Direction, "focus_out_event",
      Unselect_Field'Access, Controller);

   Gtk_New (Event_Dialog.Combo12);
   Set_Case_Sensitive (Event_Dialog.Combo12, False);
   Set_Use_Arrows (Event_Dialog.Combo12, True);
   Set_Use_Arrows_Always (Event_Dialog.Combo12, False);
   String_List.Append (Combo12_Items, -"West");
   String_List.Append (Combo12_Items, -"East");
   Combo.Set_Popdown_Strings (Event_Dialog.Combo12, Combo12_Items);
   Free_String_List (Combo12_Items);
   Attach (Event_Dialog.Table1, Event_Dialog.Combo12, 4, 5, 4, 5,
     Expand or Fill, 0,
     0, 0);

   Event_Dialog.Long_Direction := Get_Entry (Event_Dialog.Combo12);
   Set_USize (Event_Dialog.Long_Direction, 40, 22);
   Set_Editable (Event_Dialog.Long_Direction, True);
   Set_Max_Length (Event_Dialog.Long_Direction, 0);
   Set_Text (Event_Dialog.Long_Direction, -"West");
   Set_Visibility (Event_Dialog.Long_Direction, True);
   Return_Callback.Connect
     (Event_Dialog.Long_Direction, "focus_in_event",
      Select_Field'Access, Controller);

   Return_Callback.Connect
     (Event_Dialog.Long_Direction, "focus_out_event",
      Unselect_Field'Access, Controller);

end Initialize;

end Event_Dialog_Pkg;
