------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                              FILTER_PANELS                               --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.3 $
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------
with Gtk.Enums; use Gtk.Enums;
with Gtk.Widget; use Gtk.Widget;
with Gtk.Radio_Button; use Gtk.Radio_Button;

with Callbacks_Astroframes; use Callbacks_Astroframes;
with Astroframes_Intl; use Astroframes_Intl;

with Filter_Panels.Callbacks;
use Filter_Panels.Callbacks;

--  Collection of selectors for various primary direction options,
--  relative to either the promissors or significators
package body Filter_Panels is
   procedure Gtk_New (Panel : out Filter_Panel_Access) is
   begin
      Panel := new Filter_Panel;
   end Gtk_New;

   procedure Initialize
     (Panel : access Filter_Panel'Class;
      Label : String;
      Controller : Controller_Ptr) is

      Hbox31_Group : Widget_SList.GSList;
   begin
      Initialize_Vbox (Panel, False, 0);

      Gtk_New (Panel.Label131, -(Label & "s"));
      Set_Alignment (Panel.Label131, 0.5, 0.5);
      Set_Padding (Panel.Label131, 0, 5);
      Set_Justify (Panel.Label131, Justify_Center);
      Set_Line_Wrap (Panel.Label131, False);
      Pack_Start (Panel,
                  Panel.Label131, False, False, 0);

      Gtk_New (Panel.Frame11, -(Label & " Bodies"));
      Set_Shadow_Type (Panel.Frame11, Shadow_Etched_In);
      Pack_Start (Panel,
                  Panel.Frame11, False, False, 0);

      Gtk_New (Panel.Bodies);
      Initialize (Panel.Bodies, Controller);
      Add (Panel.Frame11,
           Panel.Bodies);

      Gtk_New (Panel.Frame9,
               -(Label & " Cusps and Sensitive Points"));
      Set_Shadow_Type (Panel.Frame9, Shadow_Etched_In);
      Pack_Start (Panel,
                  Panel.Frame9, False, False, 0);

      Gtk_New_Vbox (Panel.Vbox21, False, 0);
      Add (Panel.Frame9, Panel.Vbox21);

      Gtk_New_Hbox (Panel.Hbox31, True, 0);
      Pack_Start (Panel.Vbox21,
                  Panel.Hbox31, False, False, 0);

      Gtk_New (Panel.Nocusps_Button, Hbox31_Group,
               -"No Cusps");
      Hbox31_Group := Group (Panel.Nocusps_Button);
      Set_Active (Panel.Nocusps_Button, False);
      Pack_Start (Panel.Hbox31,
                  Panel.Nocusps_Button, False, False, 0);
      Radio_Button_Callback.Connect
        (Panel.Nocusps_Button, "toggled",
         Radio_Button_Callback.To_Marshaller
         (On_Nocusps_Button_Toggled'Access),
         Controller);

      Gtk_New (Panel.Angles, Hbox31_Group, -"Angles Only");
      Hbox31_Group := Group (Panel.Angles);
      Set_Active (Panel.Angles, True);
      Pack_Start (Panel.Hbox31,
                  Panel.Angles, False, False, 0);
      Radio_Button_Callback.Connect
        (Panel.Angles, "toggled",
         Radio_Button_Callback.To_Marshaller (On_Angles_Toggled'Access),
         Controller);

      Gtk_New (Panel.Allcusps_Button, Hbox31_Group,
               -"All Cusps");
      Hbox31_Group := Group (Panel.Allcusps_Button);
      Set_Active (Panel.Allcusps_Button, False);
      Pack_Start (Panel.Hbox31,
                  Panel.Allcusps_Button, False, False, 0);
      Radio_Button_Callback.Connect
        (Panel.Allcusps_Button, "toggled",
         Radio_Button_Callback.To_Marshaller
         (On_Allcusps_Button_Toggled'Access),
         Controller);

      Gtk_New (Panel.Table6, 1, 2, True);
      Set_Row_Spacings (Panel.Table6, 0);
      Set_Col_Spacings (Panel.Table6, 0);
      Pack_Start (Panel.Vbox21,
                  Panel.Table6, False, False, 0);

      Gtk_New (Panel.Pof_Button, -"Part of Fortune");
      Set_Active (Panel.Pof_Button, True);
      Attach (Panel.Table6,
              Panel.Pof_Button, 0, 1, 0, 1,
              Fill, 0,
              0, 0);
      Check_Button_Callback.Connect
        (Panel.Pof_Button, "toggled",
         Check_Button_Callback.To_Marshaller (On_Pof_Button_Toggled'Access),
         Controller);

      Gtk_New (Panel.Frame5, -(Label & " Aspect Points"));
      Set_Shadow_Type (Panel.Frame5, Shadow_Etched_In);
      Pack_Start (Panel,
                  Panel.Frame5, False, False, 0);

      Gtk_New (Panel.Aspects);
      Initialize (Panel.Aspects, Controller);
      Add (Panel.Frame5,
           Panel.Aspects);

   end Initialize;

end Filter_Panels;
