------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                              FILTER_PANELS                               --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.3 $
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with Gtk.Box; use Gtk.Box;
with Gtk.Label; use Gtk.Label;
with Gtk.Frame; use Gtk.Frame;
with Gtk.Button; use Gtk.Button;
with Gtk.Check_Button; use Gtk.Check_Button;
with Gtk.Radio_Button; use Gtk.Radio_Button;
with Gtk.Table; use Gtk.Table;

with Aspect_Selector; use Aspect_Selector;
with Body_Selector; use Body_Selector;

with MVC; use MVC;

--  Collection of selectors for various primary direction options,
--  relative to either the promissors or significators
package Filter_Panels is

   type Filter_Panel is new Gtk_Vbox_Record with record
      Label131 : Gtk_Label;
      Frame11 : Gtk_Frame;
      Bodies : Body_Selectors_Access;
      Label128 : Gtk_Label;
      Button3 : Gtk_Button;
      Button4 : Gtk_Button;
      Frame9 : Gtk_Frame;
      Vbox21 : Gtk_Vbox;
      Hbox31 : Gtk_Hbox;
      Nocusps_Button : Gtk_Radio_Button;
      Angles : Gtk_Radio_Button;
      Allcusps_Button : Gtk_Radio_Button;
      Table6 : Gtk_Table;
      Pof_Button : Gtk_Check_Button;
      Frame5 : Gtk_Frame;
      Aspects : Aspect_Selectors_Access;
   end record;

   type Filter_Panel_Access is access all Filter_Panel'Class;

   procedure Gtk_New (Panel : out Filter_Panel_Access);

   procedure Initialize
     (Panel : access Filter_Panel'Class;
      Label : String;
      Controller : Controller_Ptr);

end Filter_Panels;
