------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                       FILTER_PRIMARIES.CALLBACKS                         --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.4 $
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with Gtk.Check_Button; use Gtk.Check_Button;
with Gtk.Widget; use Gtk.Widget;
with Gtk.Arguments; use Gtk.Arguments;

with MVC; use MVC;

package Filter_Primaries_Dialog_Pkg.Callbacks is

   --  Discard changes and close dialog
   function On_Filter_Primaries_Dialog_Delete_Event
     (Object : access Gtk_Widget_Record'Class;
      Params : Gtk.Arguments.Gtk_Args;
      Controller : Controller_Ptr) return Boolean;

   procedure On_Ok_Button_Clicked
     (Object : access Gtk_Button_Record'Class;
      Controller : Controller_Ptr);

   procedure On_Apply_Button_Clicked
     (Object : access Gtk_Button_Record'Class;
      Controller : Controller_Ptr);

   procedure On_Cancel_Button_Clicked
     (Object : access Gtk_Button_Record'Class;
      Controller : Controller_Ptr);

   procedure On_Parallel_Button_Toggled
     (Object : access Gtk_Check_Button_Record'Class;
     Controller : Controller_Ptr);

   procedure On_Rapt_Parallels_Button_Toggled
     (Object : access Gtk_Check_Button_Record'Class;
     Controller : Controller_Ptr);

   procedure On_Direct_Button_Toggled
     (Object : access Gtk_Check_Button_Record'Class;
     Controller : Controller_Ptr);

   procedure On_Converse_Button_Toggled
     (Object : access Gtk_Check_Button_Record'Class;
     Controller : Controller_Ptr);

end Filter_Primaries_Dialog_Pkg.Callbacks;
