------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                         MAIN_WINDOW_PKG.CALLBACKS                        --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.5 $
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with Gtk.Widget; use Gtk.Widget;

with Main_Controllers; use Main_Controllers;

--  Handle callbacks for main window of AstroFrames
package body Main_Window_Pkg.Callbacks is

   use Gtk.Arguments;

   ---------------------------------
   -- On_Main_Window_Delete_Event --
   ---------------------------------

   function On_Main_Window_Delete_Event
     (Object : access Gtk_Widget_Record'Class;
      Params : Gtk.Arguments.Gtk_Args;
      Controller : Controller_Ptr) return Boolean
   is
   begin
      Quit_Event (Main_Controller (Controller.all)'Access);
      return True;
   end On_Main_Window_Delete_Event;

   -----------------------
   -- On_Open1_Activate --
   -----------------------

   procedure On_Open1_Activate
     (Object : access Gtk_Menu_Item_Record'Class;
      Controller : Controller_Ptr)
   is
   begin
      Restore_Event (Main_Controller (Controller.all)'Access);
   end On_Open1_Activate;

   --------------------------------
   -- On_Save_Selected1_Activate --
   --------------------------------

   procedure On_Save_Selected1_Activate
     (Object : access Gtk_Menu_Item_Record'Class;
      Controller : Controller_Ptr)
   is
   begin
      Save_Selected_Events (Main_Controller (Controller.all)'Access);
   end On_Save_Selected1_Activate;

   ---------------------------
   -- On_Save_All1_Activate --
   ---------------------------

   procedure On_Save_All1_Activate
     (Object : access Gtk_Menu_Item_Record'Class;
      Controller : Controller_Ptr)
   is
   begin
      Save_Modified_Events (Main_Controller (Controller.all)'Access);
   end On_Save_All1_Activate;

   -----------------------
   -- On_Quit1_Activate --
   -----------------------

   procedure On_Quit1_Activate
     (Object : access Gtk_Menu_Item_Record'Class;
      Controller : Controller_Ptr)
   is
   begin
      Quit_Event (Main_Controller (Controller.all)'Access);
   end On_Quit1_Activate;

   ------------------------------
   -- On_Conventional_Activate --
   ------------------------------

   procedure On_Conventional_Activate
     (Object : access Gtk_Radio_Menu_Item_Record'Class;
      Controller : Controller_Ptr)
   is
   begin
      Select_Conventional_Coordinates
        (Main_Controller (Controller.all)'Access);
   end On_Conventional_Activate;

   --------------------------------------
   -- On_Topocentric_Apparent_Activate --
   --------------------------------------

   procedure On_Topocentric_Apparent_Activate
     (Object : access Gtk_Radio_Menu_Item_Record'Class;
      Controller : Controller_Ptr)
   is
   begin
      Select_Apparent_Coordinates (Main_Controller (Controller.all)'Access);
   end On_Topocentric_Apparent_Activate;

   ----------------------------------
   -- On_Topocentric_True_Activate --
   ----------------------------------

   procedure On_Topocentric_True_Activate
     (Object : access Gtk_Radio_Menu_Item_Record'Class;
      Controller : Controller_Ptr)
   is
   begin
      Select_True_Coordinates (Main_Controller (Controller.all)'Access);
   end On_Topocentric_True_Activate;

   ----------------------------------
   -- On_Event_Directory1_Activate --
   ----------------------------------

   procedure On_Event_Directory1_Activate
     (Object : access Gtk_Menu_Item_Record'Class;
      Controller : Controller_Ptr)
   is
   begin
      Set_Event_Directory (Main_Controller (Controller.all)'Access);
   end On_Event_Directory1_Activate;

   -----------------------------------
   -- On_Default_Location1_Activate --
   -----------------------------------

   procedure On_Default_Location1_Activate
     (Object : access Gtk_Menu_Item_Record'Class;
      Controller : Controller_Ptr)
   is
   begin
      Set_Default_Location (Main_Controller (Controller.all)'Access);
   end On_Default_Location1_Activate;

   --------------------------------
   -- On_Select_Bodies1_Activate --
   --------------------------------

   procedure On_Select_Bodies1_Activate
     (Object : access Gtk_Menu_Item_Record'Class;
      Controller : Controller_Ptr)
   is
   begin
      --  Prepare dialog controller for modifications to selections
      Select_Bodies_Event (Main_Controller (Controller.all)'Access);
   end On_Select_Bodies1_Activate;

   --------------------------------
   -- On_Filter_Primaries_Activate --
   --------------------------------

   procedure On_Filter_Primaries_Activate
     (Object : access Gtk_Menu_Item_Record'Class;
      Controller : Controller_Ptr) is
   begin
      Filter_Primaries (Main_Controller (Controller.all)'Access);
   end On_Filter_Primaries_Activate;

   -------------------------------------
   -- On_Table_Of_Positions1_Activate --
   -------------------------------------

   procedure On_Table_Of_Positions1_Activate
     (Object : access Gtk_Check_Menu_Item_Record'Class;
      Controller : Controller_Ptr)
   is
   begin
      Select_Table_Of_Positions (Main_Controller (Controller.all)'Access);
   end On_Table_Of_Positions1_Activate;

   -------------------------------------
   -- On_Conventional_Chart1_Activate --
   -------------------------------------

   procedure On_Conventional_Chart1_Activate
     (Object : access Gtk_Check_Menu_Item_Record'Class;
      Controller : Controller_Ptr)
   is
   begin
      Select_Conventional_Chart (Main_Controller (Controller.all)'Access);
   end On_Conventional_Chart1_Activate;

   -------------------------------
   -- On_Solar_Zodiac1_Activate --
   -------------------------------

   procedure On_Solar_Zodiac1_Activate
     (Object : access Gtk_Check_Menu_Item_Record'Class;
      Controller : Controller_Ptr)
   is
   begin
      Select_Solar_Zodiac (Main_Controller (Controller.all)'Access);
   end On_Solar_Zodiac1_Activate;

   -------------------------------------
   -- On_Terrestrial_Zodiac1_Activate --
   -------------------------------------

   procedure On_Terrestrial_Zodiac1_Activate
     (Object : access Gtk_Check_Menu_Item_Record'Class;
      Controller : Controller_Ptr)
   is
   begin
      Select_Terrestrial_Zodiac (Main_Controller (Controller.all)'Access);
   end On_Terrestrial_Zodiac1_Activate;

   -------------------------------
   -- On_Lunar_Zodiac1_Activate --
   -------------------------------

   procedure On_Lunar_Zodiac1_Activate
     (Object : access Gtk_Check_Menu_Item_Record'Class;
      Controller : Controller_Ptr)
   is
   begin
      Select_Lunar_Zodiac (Main_Controller (Controller.all)'Access);
   end On_Lunar_Zodiac1_Activate;

   -------------------------------------
   -- On_Primary_Directions1_Activate --
   -------------------------------------

   procedure On_Primary_Directions1_Activate
     (Object : access Gtk_Menu_Item_Record'Class;
      Controller : Controller_Ptr)
   is
   begin
      Primary_Directions_Event (Main_Controller (Controller.all)'Access);
   end On_Primary_Directions1_Activate;

   -------------------------------------------
   -- On_Symbolic_Time_Calculator1_Activate --
   -------------------------------------------

   procedure On_Symbolic_Time_Calculator1_Activate
     (Object : access Gtk_Menu_Item_Record'Class;
      Controller : Controller_Ptr)
   is
   begin
      null;
   end On_Symbolic_Time_Calculator1_Activate;

   ---------------------------
   -- On_New_Button_Clicked --
   ---------------------------

   procedure On_New_Button_Clicked
     (Object : access Gtk_Widget_Record'Class;
      Params : Gtk.Arguments.Gtk_Args;
      Controller : Controller_Ptr)
   is
   begin
      New_Event (Main_Controller (Controller.all)'Access);
   end On_New_Button_Clicked;

   ----------------------------
   -- On_Open_Button_Clicked --
   ----------------------------

   procedure On_Open_Button_Clicked
     (Object : access Gtk_Widget_Record'Class;
      Params : Gtk.Arguments.Gtk_Args;
      Controller : Controller_Ptr)
   is
   begin
      Restore_Event (Main_Controller (Controller.all)'Access);
   end On_Open_Button_Clicked;

   ----------------------------
   -- On_Save_Button_Clicked --
   ----------------------------

   procedure On_Save_Button_Clicked
     (Object : access Gtk_Widget_Record'Class;
      Params : Gtk.Arguments.Gtk_Args;
      Controller : Controller_Ptr)
   is
   begin
      Save_Selected_Events (Main_Controller (Controller.all)'Access);
   end On_Save_Button_Clicked;

   ------------------------------
   -- On_Modify_Button_Clicked --
   ------------------------------

   procedure On_Modify_Button_Clicked
     (Object : access Gtk_Widget_Record'Class;
      Params : Gtk.Arguments.Gtk_Args;
      Controller : Controller_Ptr)
   is
   begin
      Modify_Selected_Events (Main_Controller (Controller.all)'Access);
   end On_Modify_Button_Clicked;

   -----------------------------
   -- On_Clone_Button_Clicked --
   -----------------------------

   procedure On_Clone_Button_Clicked
     (Object : access Gtk_Widget_Record'Class;
      Params : Gtk.Arguments.Gtk_Args;
      Controller : Controller_Ptr)
   is
   begin
      Clone_Selected_Events (Main_Controller (Controller.all)'Access);
   end On_Clone_Button_Clicked;

   ------------------------------
   -- On_Delete_Button_Clicked --
   ------------------------------

   procedure On_Delete_Button_Clicked
     (Object : access Gtk_Widget_Record'Class;
      Params : Gtk.Arguments.Gtk_Args;
      Controller : Controller_Ptr)
   is
   begin
      Delete_Selected_Events (Main_Controller (Controller.all)'Access);
   end On_Delete_Button_Clicked;

   -------------------------------
   -- On_Display_Button_Clicked --
   -------------------------------

   procedure On_Display_Button_Clicked
     (Object : access Gtk_Widget_Record'Class;
      Params : Gtk.Arguments.Gtk_Args;
      Controller : Controller_Ptr)
   is
   begin
      Display_Selected_Events (Main_Controller (Controller.all)'Access);
   end On_Display_Button_Clicked;

end Main_Window_Pkg.Callbacks;
