------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                        MAIN_WINDOW_PKG.CALLBACKS                         --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.4 $
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with Gtk.Arguments;
with Gtk.Widget; use Gtk.Widget;

with MVC; use MVC;

--  Handle callbacks from AstroFrames main window
package Main_Window_Pkg.Callbacks is

   function On_Main_Window_Delete_Event
     (Object : access Gtk_Widget_Record'Class;
      Params : Gtk.Arguments.Gtk_Args;
      Controller : Controller_Ptr) return Boolean;

   procedure On_Open1_Activate
     (Object : access Gtk_Menu_Item_Record'Class;
      Controller : Controller_Ptr);

   procedure On_Save_Selected1_Activate
     (Object : access Gtk_Menu_Item_Record'Class;
      Controller : Controller_Ptr);

   procedure On_Save_All1_Activate
     (Object : access Gtk_Menu_Item_Record'Class;
      Controller : Controller_Ptr);

   procedure On_Quit1_Activate
     (Object : access Gtk_Menu_Item_Record'Class;
      Controller : Controller_Ptr);

   procedure On_Conventional_Activate
     (Object : access Gtk_Radio_Menu_Item_Record'Class;
      Controller : Controller_Ptr);

   procedure On_Topocentric_Apparent_Activate
     (Object : access Gtk_Radio_Menu_Item_Record'Class;
      Controller : Controller_Ptr);

   procedure On_Topocentric_True_Activate
     (Object : access Gtk_Radio_Menu_Item_Record'Class;
      Controller : Controller_Ptr);

   procedure On_Event_Directory1_Activate
     (Object : access Gtk_Menu_Item_Record'Class;
      Controller : Controller_Ptr);

   procedure On_Default_Location1_Activate
     (Object : access Gtk_Menu_Item_Record'Class;
      Controller : Controller_Ptr);

   procedure On_Select_Bodies1_Activate
     (Object : access Gtk_Menu_Item_Record'Class;
      Controller : Controller_Ptr);

   procedure On_Filter_Primaries_Activate
     (Object : access Gtk_Menu_Item_Record'Class;
      Controller : Controller_Ptr);

   procedure On_Table_Of_Positions1_Activate
     (Object : access Gtk_Check_Menu_Item_Record'Class;
      Controller : Controller_Ptr);

   procedure On_Conventional_Chart1_Activate
     (Object : access Gtk_Check_Menu_Item_Record'Class;
      Controller : Controller_Ptr);

   procedure On_Solar_Zodiac1_Activate
     (Object : access Gtk_Check_Menu_Item_Record'Class;
      Controller : Controller_Ptr);

   procedure On_Terrestrial_Zodiac1_Activate
     (Object : access Gtk_Check_Menu_Item_Record'Class;
      Controller : Controller_Ptr);

   procedure On_Lunar_Zodiac1_Activate
     (Object : access Gtk_Check_Menu_Item_Record'Class;
      Controller : Controller_Ptr);

   procedure On_Primary_Directions1_Activate
     (Object : access Gtk_Menu_Item_Record'Class;
      Controller : Controller_Ptr);

   procedure On_Symbolic_Time_Calculator1_Activate
     (Object : access Gtk_Menu_Item_Record'Class;
      Controller : Controller_Ptr);

   procedure On_New_Button_Clicked
     (Object : access Gtk_Widget_Record'Class;
      Params : Gtk.Arguments.Gtk_Args;
      Controller : Controller_Ptr);

   procedure On_Open_Button_Clicked
     (Object : access Gtk_Widget_Record'Class;
      Params : Gtk.Arguments.Gtk_Args;
      Controller : Controller_Ptr);

   procedure On_Save_Button_Clicked
     (Object : access Gtk_Widget_Record'Class;
      Params : Gtk.Arguments.Gtk_Args;
      Controller : Controller_Ptr);

   procedure On_Modify_Button_Clicked
     (Object : access Gtk_Widget_Record'Class;
      Params : Gtk.Arguments.Gtk_Args;
      Controller : Controller_Ptr);

   procedure On_Clone_Button_Clicked
     (Object : access Gtk_Widget_Record'Class;
      Params : Gtk.Arguments.Gtk_Args;
      Controller : Controller_Ptr);

   procedure On_Delete_Button_Clicked
     (Object : access Gtk_Widget_Record'Class;
      Params : Gtk.Arguments.Gtk_Args;
      Controller : Controller_Ptr);

   procedure On_Display_Button_Clicked
     (Object : access Gtk_Widget_Record'Class;
      Params : Gtk.Arguments.Gtk_Args;
      Controller : Controller_Ptr);

end Main_Window_Pkg.Callbacks;
