------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                             NOTES_DIALOG_PKG                             --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.3 $
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with Gtk; use Gtk;
with Gtk.Widget;      use Gtk.Widget;
with Gtk.Enums;       use Gtk.Enums;
with Callbacks_Astroframes; use Callbacks_Astroframes;
with Astroframes_Intl; use Astroframes_Intl;
with Notes_Dialog_Pkg.Callbacks; use Notes_Dialog_Pkg.Callbacks;

--  Dialog for entering event notes
package body Notes_Dialog_Pkg is

procedure Gtk_New (Notes_Dialog : out Notes_Dialog_Access) is
begin
   Notes_Dialog := new Notes_Dialog_Record;
--    Notes_Dialog_Pkg.Initialize (Notes_Dialog);
end Gtk_New;

procedure Initialize
  (Notes_Dialog : access Notes_Dialog_Record'Class;
   Controller : Controller_Ptr) is
   pragma Suppress (All_Checks);
begin
   Gtk.Dialog.Initialize (Notes_Dialog);
   Set_USize (Notes_Dialog, 325, 200);
   Set_Title (Notes_Dialog, -"AstroFrames:  Event Notes");
   Set_Policy (Notes_Dialog, True, True, False);
   Set_Position (Notes_Dialog, Win_Pos_None);
   Set_Modal (Notes_Dialog, False);

   Notes_Dialog.Dialog_Vbox6 := Get_Vbox (Notes_Dialog);
   Set_Homogeneous (Notes_Dialog.Dialog_Vbox6, False);
   Set_Spacing (Notes_Dialog.Dialog_Vbox6, 0);

   Notes_Dialog.Dialog_Action_Area6 := Get_Action_Area (Notes_Dialog);
   Set_Border_Width (Notes_Dialog.Dialog_Action_Area6, 10);
   Set_Homogeneous (Notes_Dialog.Dialog_Action_Area6, True);
   Set_Spacing (Notes_Dialog.Dialog_Action_Area6, 5);

   Gtk_New (Notes_Dialog.Hbuttonbox2);
   Pack_Start (Notes_Dialog.Dialog_Action_Area6, Notes_Dialog.Hbuttonbox2, True, True, 0);
   Set_Spacing (Notes_Dialog.Hbuttonbox2, 30);
   Set_Layout (Notes_Dialog.Hbuttonbox2, Buttonbox_Default_Style);
   Set_Child_Size (Notes_Dialog.Hbuttonbox2, 85, 27);
   Set_Child_Ipadding (Notes_Dialog.Hbuttonbox2, 7, 0);

   Gtk_New (Notes_Dialog.Ok_Button, -"OK");
   Set_Relief (Notes_Dialog.Ok_Button, Relief_Normal);
   Set_Flags (Notes_Dialog.Ok_Button, Can_Default);
   Button_Callback.Connect
     (Notes_Dialog.Ok_Button, "clicked",
      Button_Callback.To_Marshaller (On_Ok_Button_Clicked'Access),
      Controller);
   Add (Notes_Dialog.Hbuttonbox2, Notes_Dialog.Ok_Button);

   Gtk_New (Notes_Dialog.Cancel_Button, -"Cancel");
   Set_Relief (Notes_Dialog.Cancel_Button, Relief_Normal);
   Set_Flags (Notes_Dialog.Cancel_Button, Can_Default);
   Button_Callback.Connect
     (Notes_Dialog.Cancel_Button, "clicked",
      Button_Callback.To_Marshaller (On_Cancel_Button_Clicked'Access),
      Controller);
   Add (Notes_Dialog.Hbuttonbox2, Notes_Dialog.Cancel_Button);

   Gtk_New (Notes_Dialog.Scrolledwindow8);
   Pack_Start (Notes_Dialog.Dialog_Vbox6, Notes_Dialog.Scrolledwindow8, True, True, 0);
   Set_Policy (Notes_Dialog.Scrolledwindow8, Policy_Never, Policy_Always);

   Gtk_New (Notes_Dialog.Notes_Entry);
   Add (Notes_Dialog.Scrolledwindow8, Notes_Dialog.Notes_Entry);
   Set_Editable (Notes_Dialog.Notes_Entry, True);

end Initialize;

end Notes_Dialog_Pkg;
