------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                           POSITIONS_DIALOG_PKG                           --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.3 $
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with Gtk; use Gtk;
with Gtk.Enums;       use Gtk.Enums;

with Callbacks_Astroframes; use Callbacks_Astroframes;
with Astroframes_Intl; use Astroframes_Intl;
with Positions_Dialog_Pkg.Callbacks; use Positions_Dialog_Pkg.Callbacks;

--  Positions display
package body Positions_Dialog_Pkg is

procedure Gtk_New (Positions_Dialog : out Positions_Dialog_Access) is
begin
   Positions_Dialog := new Positions_Dialog_Record;
end Gtk_New;

procedure Initialize
  (Positions_Dialog : access Positions_Dialog_Record'Class;
   Controller : Controller_Ptr) is
   pragma Suppress (All_Checks);
begin
   Gtk.Dialog.Initialize (Positions_Dialog);
   Set_USize (Positions_Dialog, 580, 350);
   Return_Callback.Connect
     (Positions_Dialog, "delete_event",
      On_Positions_Dialog_Delete_Event'Access,
      Controller);
   Set_Title (Positions_Dialog, -"AstroFrames:  Positions for ");
   Set_Policy (Positions_Dialog, True, True, False);
   Set_Position (Positions_Dialog, Win_Pos_None);
   Set_Modal (Positions_Dialog, False);
   Positions_Dialog.Dialog_Vbox7 := Get_Vbox (Positions_Dialog);
   Set_Homogeneous (Positions_Dialog.Dialog_Vbox7, False);
   Set_Spacing (Positions_Dialog.Dialog_Vbox7, 0);

   Positions_Dialog.Dialog_Action_Area7 := Get_Action_Area (Positions_Dialog);
   Set_Border_Width (Positions_Dialog.Dialog_Action_Area7, 10);
   Set_Homogeneous (Positions_Dialog.Dialog_Action_Area7, True);
   Set_Spacing (Positions_Dialog.Dialog_Action_Area7, 5);

   Gtk_New (Positions_Dialog.Toggle_Updates_Button, -"Freeze");
   Set_Relief (Positions_Dialog.Toggle_Updates_Button, Relief_Normal);
   Pack_Start (Positions_Dialog.Dialog_Action_Area7,
               Positions_Dialog.Toggle_Updates_Button, False, False, 0);

   Button_Callback.Connect
     (Positions_Dialog.Toggle_Updates_Button, "clicked",
      Button_Callback.To_Marshaller (On_Toggle_Updates_Button_Clicked'Access),
      Controller);

   Gtk_New (Positions_Dialog.Close_Button, -"Close");
   Set_Relief (Positions_Dialog.Close_Button, Relief_Normal);
   Pack_Start (Positions_Dialog.Dialog_Action_Area7,
               Positions_Dialog.Close_Button, False, False, 0);

   Button_Callback.Connect
     (Positions_Dialog.Close_Button, "clicked",
      Button_Callback.To_Marshaller (On_Close_Button_Clicked'Access),
      Controller);

   Gtk_New_Vbox (Positions_Dialog.Vbox11, False, 0);
   Pack_Start (Positions_Dialog.Dialog_Vbox7, Positions_Dialog.Vbox11,
               True, True, 0);

   Gtk_New (Positions_Dialog.Menubar3);
   Set_Shadow_Type (Positions_Dialog.Menubar3, Shadow_Out);
   Pack_Start (Positions_Dialog.Vbox11, Positions_Dialog.Menubar3,
               False, False, 0);

   Gtk_New (Positions_Dialog.File2, -"File");
   Set_Right_Justify (Positions_Dialog.File2, False);
   Add (Positions_Dialog.Menubar3, Positions_Dialog.File2);

   Gtk_New (Positions_Dialog.File2_Menu);
   Set_Submenu (Positions_Dialog.File2, Positions_Dialog.File2_Menu);

   Gtk_New (Positions_Dialog.Export1, -"Export");
   Set_Right_Justify (Positions_Dialog.Export1, False);
   Menu_Item_Callback.Connect
     (Positions_Dialog.Export1, "activate",
      Menu_Item_Callback.To_Marshaller (On_Export1_Activate'Access),
      Controller);
   Add (Positions_Dialog.File2_Menu, Positions_Dialog.Export1);

   Gtk_New (Positions_Dialog.Scrolledwindow9);
   Set_Policy (Positions_Dialog.Scrolledwindow9, Policy_Automatic,
               Policy_Automatic);
   Pack_Start (Positions_Dialog.Vbox11, Positions_Dialog.Scrolledwindow9,
               True, True, 0);

   Gtk_New (Positions_Dialog.Viewport2);
   Set_Shadow_Type (Positions_Dialog.Viewport2, Shadow_In);
   Add (Positions_Dialog.Scrolledwindow9, Positions_Dialog.Viewport2);

   Gtk_New_Hbox (Positions_Dialog.Hbox23, False, 0);
   Add (Positions_Dialog.Viewport2, Positions_Dialog.Hbox23);

   Gtk_New (Positions_Dialog.Header_List, 1);
   Set_Selection_Mode (Positions_Dialog.Header_List, Selection_Single);
   Set_Shadow_Type (Positions_Dialog.Header_List, Shadow_In);
   Set_Show_Titles (Positions_Dialog.Header_List, True);
   Set_Column_Width (Positions_Dialog.Header_List, 0, 94);
   Pack_Start (Positions_Dialog.Hbox23, Positions_Dialog.Header_List,
               True, True, 0);

   Gtk_New (Positions_Dialog.Label71, -("Point"));
   Set_Alignment (Positions_Dialog.Label71, 0.5, 0.5);
   Set_Padding (Positions_Dialog.Label71, 0, 0);
   Set_Justify (Positions_Dialog.Label71, Justify_Center);
   Set_Line_Wrap (Positions_Dialog.Label71, False);
   Set_Column_Widget (Positions_Dialog.Header_List, 0,
                      Positions_Dialog.Label71);

   Gtk_New (Positions_Dialog.Ecliptic_Table, 3);
   Set_Selection_Mode (Positions_Dialog.Ecliptic_Table, Selection_Single);
   Set_Shadow_Type (Positions_Dialog.Ecliptic_Table, Shadow_In);
   Set_Show_Titles (Positions_Dialog.Ecliptic_Table, True);
   Set_Column_Width (Positions_Dialog.Ecliptic_Table, 0, 84);
   Set_Column_Width (Positions_Dialog.Ecliptic_Table, 1, 15);
   Set_Column_Width (Positions_Dialog.Ecliptic_Table, 2, 69);
   Pack_Start (Positions_Dialog.Hbox23, Positions_Dialog.Ecliptic_Table,
               True, True, 0);

   Gtk_New (Positions_Dialog.Label107, -("Longitude"));
   Set_Alignment (Positions_Dialog.Label107, 0.5, 0.5);
   Set_Padding (Positions_Dialog.Label107, 0, 0);
   Set_Justify (Positions_Dialog.Label107, Justify_Center);
   Set_Line_Wrap (Positions_Dialog.Label107, False);
   Set_Column_Widget (Positions_Dialog.Ecliptic_Table, 0,
                      Positions_Dialog.Label107);

   Gtk_New (Positions_Dialog.Label108);
   Set_Alignment (Positions_Dialog.Label108, 0.5, 0.5);
   Set_Padding (Positions_Dialog.Label108, 0, 0);
   Set_Justify (Positions_Dialog.Label108, Justify_Center);
   Set_Line_Wrap (Positions_Dialog.Label108, False);
   Set_Column_Widget (Positions_Dialog.Ecliptic_Table, 1,
                      Positions_Dialog.Label108);

   Gtk_New (Positions_Dialog.Label109, -("Latitude"));
   Set_Alignment (Positions_Dialog.Label109, 0.5, 0.5);
   Set_Padding (Positions_Dialog.Label109, 0, 0);
   Set_Justify (Positions_Dialog.Label109, Justify_Center);
   Set_Line_Wrap (Positions_Dialog.Label109, False);
   Set_Column_Widget (Positions_Dialog.Ecliptic_Table, 2,
                      Positions_Dialog.Label109);

   Gtk_New (Positions_Dialog.Equator_Table, 2);
   Set_Selection_Mode (Positions_Dialog.Equator_Table, Selection_Single);
   Set_Shadow_Type (Positions_Dialog.Equator_Table, Shadow_In);
   Set_Show_Titles (Positions_Dialog.Equator_Table, True);
   Set_Column_Width (Positions_Dialog.Equator_Table, 0, 80);
   Set_Column_Width (Positions_Dialog.Equator_Table, 1, 72);
   Pack_Start (Positions_Dialog.Hbox23, Positions_Dialog.Equator_Table,
               True, True, 0);

   Gtk_New (Positions_Dialog.Label66, -("RA"));
   Set_Alignment (Positions_Dialog.Label66, 0.5, 0.5);
   Set_Padding (Positions_Dialog.Label66, 0, 0);
   Set_Justify (Positions_Dialog.Label66, Justify_Center);
   Set_Line_Wrap (Positions_Dialog.Label66, False);
   Set_Column_Widget (Positions_Dialog.Equator_Table, 0,
                      Positions_Dialog.Label66);

   Gtk_New (Positions_Dialog.Label67, -("Declination"));
   Set_Alignment (Positions_Dialog.Label67, 0.5, 0.5);
   Set_Padding (Positions_Dialog.Label67, 0, 0);
   Set_Justify (Positions_Dialog.Label67, Justify_Center);
   Set_Line_Wrap (Positions_Dialog.Label67, False);
   Set_Column_Widget (Positions_Dialog.Equator_Table, 1,
                      Positions_Dialog.Label67);

   Gtk_New (Positions_Dialog.Terra_List, 1);
   Set_Selection_Mode (Positions_Dialog.Terra_List, Selection_Single);
   Set_Shadow_Type (Positions_Dialog.Terra_List, Shadow_In);
   Set_Show_Titles (Positions_Dialog.Terra_List, True);
   Set_Column_Width (Positions_Dialog.Terra_List, 0, 80);
   Pack_Start (Positions_Dialog.Hbox23, Positions_Dialog.Terra_List,
               True, True, 0);

   Gtk_New (Positions_Dialog.Label72, -("Terran"));
   Set_Alignment (Positions_Dialog.Label72, 0.5, 0.5);
   Set_Padding (Positions_Dialog.Label72, 0, 0);
   Set_Justify (Positions_Dialog.Label72, Justify_Center);
   Set_Line_Wrap (Positions_Dialog.Label72, False);
   Set_Column_Widget (Positions_Dialog.Terra_List, 0,
                      Positions_Dialog.Label72);

   Gtk_New (Positions_Dialog.Solar_List, 1);
   Set_Selection_Mode (Positions_Dialog.Solar_List, Selection_Single);
   Set_Shadow_Type (Positions_Dialog.Solar_List, Shadow_In);
   Set_Show_Titles (Positions_Dialog.Solar_List, True);
   Set_Column_Width (Positions_Dialog.Solar_List, 0, 80);
   Pack_Start (Positions_Dialog.Hbox23, Positions_Dialog.Solar_List,
               True, True, 0);

   Gtk_New (Positions_Dialog.Label73, -("Solar"));
   Set_Alignment (Positions_Dialog.Label73, 0.5, 0.5);
   Set_Padding (Positions_Dialog.Label73, 0, 0);
   Set_Justify (Positions_Dialog.Label73, Justify_Center);
   Set_Line_Wrap (Positions_Dialog.Label73, False);
   Set_Column_Widget (Positions_Dialog.Solar_List, 0,
                      Positions_Dialog.Label73);

   Gtk_New (Positions_Dialog.Lunar_List, 1);
   Set_Selection_Mode (Positions_Dialog.Lunar_List, Selection_Single);
   Set_Shadow_Type (Positions_Dialog.Lunar_List, Shadow_In);
   Set_Show_Titles (Positions_Dialog.Lunar_List, True);
   Set_Column_Width (Positions_Dialog.Lunar_List, 0, 80);
   Pack_Start (Positions_Dialog.Hbox23, Positions_Dialog.Lunar_List,
               True, True, 0);

   Gtk_New (Positions_Dialog.Label74, -("Lunar"));
   Set_Alignment (Positions_Dialog.Label74, 0.5, 0.5);
   Set_Padding (Positions_Dialog.Label74, 0, 0);
   Set_Justify (Positions_Dialog.Label74, Justify_Center);
   Set_Line_Wrap (Positions_Dialog.Label74, False);
   Set_Column_Widget (Positions_Dialog.Lunar_List, 0,
                      Positions_Dialog.Label74);

end Initialize;

end Positions_Dialog_Pkg;
