------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                     PRIMARIES_DIALOG_PKG.CALLBACKS                       --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.4 $
--                                                                          --
--                       Copyright (C) 2002 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

--  Callbacks for primary directions list dialog

with Gtk.Widget; use Gtk.Widget;

with Primaries_Controllers; use Primaries_Controllers;
package body Primaries_Dialog_Pkg.Callbacks is

   use Gtk.Arguments;

   --------------------------------------
   -- On_Primaries_Dialog_Delete_Event --
   --------------------------------------

   function On_Primaries_Dialog_Delete_Event
     (Object : access Gtk_Widget_Record'Class;
      Params : Gtk.Arguments.Gtk_Args;
      Controller : Controller_Ptr) return Boolean
   is
   begin
      Close (Primaries_Controller (Controller.all)'Access);
      return True;
   end On_Primaries_Dialog_Delete_Event;

   ---------------------------------
   -- On_Calculate_Button_Clicked --
   ---------------------------------

   procedure On_Calculate_Button_Clicked
     (Object : access Gtk_Button_Record'Class;
      Controller : Controller_Ptr)
   is
   begin
      Calculate (Primaries_Controller (Controller.all)'Access);
   end On_Calculate_Button_Clicked;

   ------------------------------
   -- On_Export_Button_Clicked --
   ------------------------------

   procedure On_Export_Button_Clicked
     (Object : access Gtk_Button_Record'Class;
      Controller : Controller_Ptr)
   is
   begin
      Export (Primaries_Controller (Controller.all)'Access);
   end On_Export_Button_Clicked;

   -----------------------------
   -- On_Close_Button_Clicked --
   -----------------------------

   procedure On_Close_Button_Clicked
     (Object : access Gtk_Button_Record'Class;
      Controller : Controller_Ptr)
   is
   begin
      Close (Primaries_Controller (Controller.all)'Access);
   end On_Close_Button_Clicked;

   -------------------------
   -- On_Export2_Activate --
   -------------------------

   procedure On_Export2_Activate
     (Object : access Gtk_Menu_Item_Record'Class;
      Controller : Controller_Ptr)
   is
   begin
      null;
   end On_Export2_Activate;

   -------------------------
   -- On_Zodiacal_Toggled --
   -------------------------

   procedure On_Zodiacal_Toggled
     (Object : access Gtk_Radio_Button_Record'Class;
      Controller : Controller_Ptr)
   is
   begin
      Conditional_Update (Primaries_Controller (Controller.all)'Access);
   end On_Zodiacal_Toggled;

   ----------------------
   -- On_Mundo_Toggled --
   ----------------------

   procedure On_Mundo_Toggled
     (Object : access Gtk_Radio_Button_Record'Class;
      Controller : Controller_Ptr)
   is
   begin
      Conditional_Update (Primaries_Controller (Controller.all)'Access);
   end On_Mundo_Toggled;

   ------------------------
   -- On_Conform_Toggled --
   ------------------------

   procedure On_Conform_Toggled
     (Object : access Gtk_Radio_Button_Record'Class;
      Controller : Controller_Ptr)
   is
   begin
      null;
   end On_Conform_Toggled;

   ---------------------------------
   -- On_Latitudes_Button_Clicked --
   ---------------------------------

   procedure On_Latitudes_Button_Clicked
     (Object : access Gtk_Button_Record'Class;
      Controller : Controller_Ptr)
   is
   begin
      null;
   end On_Latitudes_Button_Clicked;

   --------------------
   -- On_Key_Changed --
   --------------------

   procedure On_Key_Changed
     (Object : access Gtk_Entry_Record'Class;
      Controller : Controller_Ptr)
   is
   begin
      Conditional_Update (Primaries_Controller (Controller.all)'Access);
   end On_Key_Changed;

   -------------------------------
   -- On_Filters_Button_Clicked --
   -------------------------------

   procedure On_Filters_Button_Clicked
     (Object : access Gtk_Button_Record'Class;
      Controller : Controller_Ptr)
   is
   begin
      Open_Filter (Primaries_Controller (Controller.all)'Access);
   end On_Filters_Button_Clicked;

end Primaries_Dialog_Pkg.Callbacks;
