------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                     PRIMARIES_DIALOG_PKG.CALLBACKS                       --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.3 $
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

--  Callbacks for primary directions list dialog

with Gtk.Arguments;
with Gtk.Widget; use Gtk.Widget;

package Primaries_Dialog_Pkg.Callbacks is
   function On_Primaries_Dialog_Delete_Event
     (Object : access Gtk_Widget_Record'Class;
      Params : Gtk.Arguments.Gtk_Args;
      Controller : Controller_Ptr) return Boolean;

   procedure On_Calculate_Button_Clicked
     (Object : access Gtk_Button_Record'Class;
      Controller : Controller_Ptr);

   procedure On_Export_Button_Clicked
     (Object : access Gtk_Button_Record'Class;
      Controller : Controller_Ptr);

   procedure On_Close_Button_Clicked
     (Object : access Gtk_Button_Record'Class;
      Controller : Controller_Ptr);

   procedure On_Export2_Activate
     (Object : access Gtk_Menu_Item_Record'Class;
      Controller : Controller_Ptr);

   procedure On_Zodiacal_Toggled
     (Object : access Gtk_Radio_Button_Record'Class;
      Controller : Controller_Ptr);

   procedure On_Mundo_Toggled
     (Object : access Gtk_Radio_Button_Record'Class;
      Controller : Controller_Ptr);

   procedure On_Conform_Toggled
     (Object : access Gtk_Radio_Button_Record'Class;
      Controller : Controller_Ptr);

   procedure On_Latitudes_Button_Clicked
     (Object : access Gtk_Button_Record'Class;
      Controller : Controller_Ptr);

   procedure On_Key_Changed
     (Object : access Gtk_Entry_Record'Class;
      Controller : Controller_Ptr);

   procedure On_Filters_Button_Clicked
     (Object : access Gtk_Button_Record'Class;
      Controller : Controller_Ptr);

end Primaries_Dialog_Pkg.Callbacks;
