with Gtk.Window; use Gtk.Window;
with Gtk.Box; use Gtk.Box;
with Gtk.Menu_Bar; use Gtk.Menu_Bar;
with Gtk.Toolbar; use Gtk.Toolbar;
with Gtk.Frame; use Gtk.Frame;
with Gtk.Scrolled_Window; use Gtk.Scrolled_Window;
with Gtk.Clist; use Gtk.Clist;
with Gtk.Label; use Gtk.Label;
with Gtk.Hbutton_Box; use Gtk.Hbutton_Box;
with Gtk.Button; use Gtk.Button;
with Gtk.Object; use Gtk.Object;

with Gtk.Glarea;       use Gtk.Glarea;
with Gl_H; use Gl_H;

package Gl_Window_Pkg is

   type Gl_Window_Record is new Gtk_Window_Record with record
      Vbox1 : Gtk_Vbox;
      Menubar1 : Gtk_Menu_Bar;
      Toolbar1 : Gtk_Toolbar;
      Hbox1 : Gtk_Hbox;
      Gl_Frame : Gtk_Frame;
      Area     : aliased Gtk_Glarea;
      Scrolledwindow1 : Gtk_Scrolled_Window;
      Positions : Gtk_Clist;
      Label1 : Gtk_Label;
      Label2 : Gtk_Label;
      Label3 : Gtk_Label;
      Hbuttonbox1 : Gtk_Hbutton_Box;
      Button1 : Gtk_Button;
      Button2 : Gtk_Button;
      Button3 : Gtk_Button;
   end record;
   type Gl_Window_Access is access all Gl_Window_Record'Class;

   Rotate_Triangle, Rotate_Quad : Float := 0.75;
   pragma Atomic (Rotate_Triangle);
   pragma Atomic (Rotate_Quad);

   procedure Gtk_New (Gl_Window : out Gl_Window_Access);
   procedure Initialize (Gl_Window : access Gl_Window_Record'Class);

   procedure Resize_GL_Scene (Width, Height : Positive);
   procedure Draw_GL_Scene (Area : access Gtk_GlArea_Record'Class);

   Gl_Window : Gl_Window_Access;

end Gl_Window_Pkg;
