--  Generated from glut.h
--  Date: Sun Apr  6 14:32:02 1997
--
--  Command line definitions:
--      -D__ANSI_C__ -D_LANGUAGE_C -DGENERATING_ADA_BINDING -D__unix -D__sgi
--      -D__mips -D__host_mips -D__EXTENSIONS__ -D__EDG -D__DSO__ -D__STDC__
--      -D_SYSTYPE_SVR4 -D_MODERN_C -D_MIPS_SZPTR=32 -D_MIPS_SZLONG=32
--      -D_MIPS_SZINT=32 -D_MIPS_SIM=_MIPS_SIM_ABI32
--      -D_MIPS_ISA=_MIPS_ISA_MIPS1 -D_MIPS_FPSET=16 -D_MIPSEB
--

with Interfaces.C;
with Interfaces.C.Extensions;
with Interfaces.C.Strings;
with GL_H; use Gl_H;
package Glut_H is

   --  Copyright (c) Mark J. Kilgard, 1994, 1995, 1996.
   --  This program is freely distributable without licensing fees  and is
   --  provided without guarantee or warrantee expressed or  implied. This
   --  program is -not- in the public domain. *
   --  **
   --  GLUT API revision history:
   --
   --  GLUT_API_VERSION is updated to reflect incompatible GLUT
   --  API changes (interface changes, semantic changes, deletions,
   --  or additions).
   --
   --  GLUT_API_VERSION=1  First public release of GLUT.  11/29/94
   --
   --  GLUT_API_VERSION=2  Added support for OpenGL/GLX multisampling,
   --  extension.  Supports new input devices like tablet, dial and button
   --  box, and Spaceball.  Easy to query OpenGL extensions.
   --
   --  GLUT_API_VERSION=3  glutMenuStatus added.
   --
   --  *

   GLUT_API_VERSION : constant := 4;  --  VERSION 4 API NOT FINALIZED

--  **
--  GLUT implementation revision history:
--
--  GLUT_XLIB_IMPLEMENTATION is updated to reflect both GLUT
--  API revisions and implementation revisions (ie, bug fixes).
--
--  GLUT_XLIB_IMPLEMENTATION=1  mjk's first public release of
--  GLUT Xlib-based implementation.  11/29/94
--
--  GLUT_XLIB_IMPLEMENTATION=2  mjk's second public release of
--  GLUT Xlib-based implementation providing GLUT version 2
--  interfaces.
--
--  GLUT_XLIB_IMPLEMENTATION=3  mjk's GLUT 2.2 images. 4/17/95
--
--  GLUT_XLIB_IMPLEMENTATION=4  mjk's GLUT 2.3 images. 6/?/95
--
--  GLUT_XLIB_IMPLEMENTATION=5  mjk's GLUT 3.0 images. 10/?/95
--
--  GLUT_XLIB_IMPLEMENTATION=7  mjk's GLUT 3.1+ with glutWarpPoitner.  7/24/96
--
--  GLUT_XLIB_IMPLEMENTATION=8  mjk's GLUT 3.1+ with glutWarpPoitner
--  and video resize.  1/3/97
--  *

   GLUT_XLIB_IMPLEMENTATION : constant := 7;

   --  Display mode bit masks.

   GLUT_RGB                 : constant := 0;
   GLUT_RGBA                : constant := 0;
   GLUT_INDEX               : constant := 1;
   GLUT_SINGLE              : constant := 0;
   GLUT_DOUBLE              : constant := 2;
   GLUT_ACCUM               : constant := 4;
   GLUT_ALPHA               : constant := 8;
   GLUT_DEPTH               : constant := 16;
   GLUT_STENCIL             : constant := 32;
   GLUT_MULTISAMPLE         : constant := 128;
   GLUT_STEREO              : constant := 256;
   GLUT_LUMINANCE           : constant := 512;

   --  Mouse buttons.

   GLUT_LEFT_BUTTON         : constant := 0;
   GLUT_MIDDLE_BUTTON       : constant := 1;
   GLUT_RIGHT_BUTTON        : constant := 2;

   --  Mouse button callback state.

   GLUT_DOWN                : constant := 0;
   GLUT_UP                  : constant := 1;

   --  function keys

   GLUT_KEY_F1              : constant := 1;
   GLUT_KEY_F2              : constant := 2;
   GLUT_KEY_F3              : constant := 3;
   GLUT_KEY_F4              : constant := 4;
   GLUT_KEY_F5              : constant := 5;
   GLUT_KEY_F6              : constant := 6;
   GLUT_KEY_F7              : constant := 7;
   GLUT_KEY_F8              : constant := 8;
   GLUT_KEY_F9              : constant := 9;
   GLUT_KEY_F10             : constant := 10;
   GLUT_KEY_F11             : constant := 11;
   GLUT_KEY_F12             : constant := 12;

   --  directional keys

   GLUT_KEY_LEFT            : constant := 100;
   GLUT_KEY_UP              : constant := 101;
   GLUT_KEY_RIGHT           : constant := 102;
   GLUT_KEY_DOWN            : constant := 103;
   GLUT_KEY_PAGE_UP         : constant := 104;
   GLUT_KEY_PAGE_DOWN       : constant := 105;
   GLUT_KEY_HOME            : constant := 106;
   GLUT_KEY_END             : constant := 107;
   GLUT_KEY_INSERT          : constant := 108;

   --  Entry/exit callback state.

   GLUT_LEFT                : constant := 0;
   GLUT_ENTERED             : constant := 1;

   --  Menu usage callback state.

   GLUT_MENU_NOT_IN_USE     : constant := 0;
   GLUT_MENU_IN_USE         : constant := 1;

   --  Visibility callback state.

   GLUT_NOT_VISIBLE         : constant := 0;
   GLUT_VISIBLE             : constant := 1;

   --  Window status callback state.

   GLUT_HIDDEN              : constant := 0;
   GLUT_FULLY_RETAINED      : constant := 1;
   GLUT_PARTIALLY_RETAINED  : constant := 2;
   GLUT_FULLY_COVERED       : constant := 3;

   --  Color index component selection values.

   GLUT_RED                 : constant := 0;
   GLUT_GREEN               : constant := 1;
   GLUT_BLUE                : constant := 2;

   --  Layers for use.

   GLUT_NORMAL              : constant := 0;
   GLUT_OVERLAY             : constant := 1;

   --  Stroke font opaque addresses (use constants instead in source code).

   glutStrokeRoman : aliased Interfaces.C.Extensions.Void_Ptr;
#IF GNAT_WIN then
   pragma Import (DLL, glutStrokeRoman, "glutStrokeRoman", "glutStrokeRoman");
#ELSE   
   pragma Import (C, glutStrokeRoman, "glutStrokeRoman", "glutStrokeRoman");
#END IF;
   
   glutStrokeMonoRoman : aliased Interfaces.C.Extensions.Void_Ptr;
#IF GNAT_WIN then
   pragma Import (DLL,
                  glutStrokeMonoRoman,
                  "glutStrokeMonoRoman",
                  "glutStrokeMonoRoman");
#ELSE   
   pragma Import (C,
                  glutStrokeMonoRoman,
                  "glutStrokeMonoRoman",
                  "glutStrokeMonoRoman");
#END IF;   

   --  Stroke font constants (use these in GLUT program).
   --  Bitmap font opaque addresses (use constants instead in source code).

   glutBitmap9By15 : aliased Interfaces.C.Extensions.Void_Ptr;
#IF GNAT_WIN then
   pragma Import (DLL, glutBitmap9By15, "glutBitmap9By15", "glutBitmap9By15");
#ELSE   
   pragma Import (C, glutBitmap9By15, "glutBitmap9By15", "glutBitmap9By15");
#END IF;   

   glutBitmap8By13 : aliased Interfaces.C.Extensions.Void_Ptr;
#IF GNAT_WIN then
   pragma Import (DLL, glutBitmap8By13, "glutBitmap8By13", "glutBitmap8By13");
#ELSE   
   pragma Import (C, glutBitmap8By13, "glutBitmap8By13", "glutBitmap8By13");
#END IF;   

   glutBitmapTimesRoman10 : aliased Interfaces.C.Extensions.Void_Ptr;
#IF GNAT_WIN then
   pragma Import (DLL,
                  glutBitmapTimesRoman10,
                  "glutBitmapTimesRoman10",
                  "glutBitmapTimesRoman10");
#ELSE   
   pragma Import (C,
                  glutBitmapTimesRoman10,
                  "glutBitmapTimesRoman10",
                  "glutBitmapTimesRoman10");
#END IF;
   

   glutBitmapTimesRoman24 : aliased Interfaces.C.Extensions.Void_Ptr;
#IF GNAT_WIN then
   pragma Import (DLL,
                  glutBitmapTimesRoman24,
                  "glutBitmapTimesRoman24",
                  "glutBitmapTimesRoman24");
#ELSE   
   pragma Import (C,
                  glutBitmapTimesRoman24,
                  "glutBitmapTimesRoman24",
                  "glutBitmapTimesRoman24");
#END IF;
   

   glutBitmapHelvetica10 : aliased Interfaces.C.Extensions.Void_Ptr;
#IF GNAT_WIN then
   pragma Import (DLL,
                  glutBitmapHelvetica10,
                  "glutBitmapHelvetica10",
                  "glutBitmapHelvetica10");
#ELSE
   pragma Import (C,
                  glutBitmapHelvetica10,
                  "glutBitmapHelvetica10",
                  "glutBitmapHelvetica10");
#END IF;

   glutBitmapHelvetica12 : aliased Interfaces.C.Extensions.Void_Ptr;
#IF GNAT_WIN then
   pragma Import (DLL,
                  glutBitmapHelvetica12,
                  "glutBitmapHelvetica12",
                  "glutBitmapHelvetica12");
#ELSE   
   pragma Import (C,
                  glutBitmapHelvetica12,
                  "glutBitmapHelvetica12",
                  "glutBitmapHelvetica12");
#END IF;
   glutBitmapHelvetica18 : aliased Interfaces.C.Extensions.Void_Ptr;
#IF GNAT_WIN then
   pragma Import (DLL,
                  glutBitmapHelvetica18,
                  "glutBitmapHelvetica18",
                  "glutBitmapHelvetica18");
#ELSE   

   --  Bitmap font constants (use these in GLUT program).
   pragma Import (C,
                  glutBitmapHelvetica18,
                  "glutBitmapHelvetica18",
                  "glutBitmapHelvetica18");

#END IF;
   --  glutGet parameters.

   GLUT_WINDOW_X                  : constant := 100;
   GLUT_WINDOW_Y                  : constant := 101;
   GLUT_WINDOW_WIDTH              : constant := 102;
   GLUT_WINDOW_HEIGHT             : constant := 103;
   GLUT_WINDOW_BUFFER_SIZE        : constant := 104;
   GLUT_WINDOW_STENCIL_SIZE       : constant := 105;
   GLUT_WINDOW_DEPTH_SIZE         : constant := 106;
   GLUT_WINDOW_RED_SIZE           : constant := 107;
   GLUT_WINDOW_GREEN_SIZE         : constant := 108;
   GLUT_WINDOW_BLUE_SIZE          : constant := 109;
   GLUT_WINDOW_ALPHA_SIZE         : constant := 110;
   GLUT_WINDOW_ACCUM_RED_SIZE     : constant := 111;
   GLUT_WINDOW_ACCUM_GREEN_SIZE   : constant := 112;
   GLUT_WINDOW_ACCUM_BLUE_SIZE    : constant := 113;
   GLUT_WINDOW_ACCUM_ALPHA_SIZE   : constant := 114;
   GLUT_WINDOW_DOUBLEBUFFER       : constant := 115;
   GLUT_WINDOW_RGBA               : constant := 116;
   GLUT_WINDOW_PARENT             : constant := 117;
   GLUT_WINDOW_NUM_CHILDREN       : constant := 118;
   GLUT_WINDOW_COLORMAP_SIZE      : constant := 119;
   GLUT_WINDOW_NUM_SAMPLES        : constant := 120;
   GLUT_WINDOW_STEREO             : constant := 121;
   GLUT_WINDOW_CURSOR             : constant := 122;
   GLUT_SCREEN_WIDTH              : constant := 200;
   GLUT_SCREEN_HEIGHT             : constant := 201;
   GLUT_SCREEN_WIDTH_MM           : constant := 202;
   GLUT_SCREEN_HEIGHT_MM          : constant := 203;
   GLUT_MENU_NUM_ITEMS            : constant := 300;
   GLUT_DISPLAY_MODE_POSSIBLE     : constant := 400;
   GLUT_INIT_WINDOW_X             : constant := 500;
   GLUT_INIT_WINDOW_Y             : constant := 501;
   GLUT_INIT_WINDOW_WIDTH         : constant := 502;
   GLUT_INIT_WINDOW_HEIGHT        : constant := 503;
   GLUT_INIT_DISPLAY_MODE         : constant := 504;
   GLUT_ELAPSED_TIME              : constant := 700;

   --  glutDeviceGet parameters.

   GLUT_HAS_KEYBOARD              : constant := 600;
   GLUT_HAS_MOUSE                 : constant := 601;
   GLUT_HAS_SPACEBALL             : constant := 602;
   GLUT_HAS_DIAL_AND_BUTTON_BOX   : constant := 603;
   GLUT_HAS_TABLET                : constant := 604;
   GLUT_NUM_MOUSE_BUTTONS         : constant := 605;
   GLUT_NUM_SPACEBALL_BUTTONS     : constant := 606;
   GLUT_NUM_BUTTON_BOX_BUTTONS    : constant := 607;
   GLUT_NUM_DIALS                 : constant := 608;
   GLUT_NUM_TABLET_BUTTONS        : constant := 609;

   --  glutLayerGet parameters.

   GLUT_OVERLAY_POSSIBLE          : constant := 800;
   GLUT_LAYER_IN_USE              : constant := 801;
   GLUT_HAS_OVERLAY               : constant := 802;
   GLUT_TRANSPARENT_INDEX         : constant := 803;
   GLUT_NORMAL_DAMAGED            : constant := 804;
   GLUT_OVERLAY_DAMAGED           : constant := 805;

   --  glutVideoResizeGet parameters.

   GLUT_VIDEO_RESIZE_POSSIBLE     : constant := 900;
   GLUT_VIDEO_RESIZE_IN_USE       : constant := 901;
   GLUT_VIDEO_RESIZE_X_DELTA      : constant := 902;
   GLUT_VIDEO_RESIZE_Y_DELTA      : constant := 903;
   GLUT_VIDEO_RESIZE_WIDTH_DELTA  : constant := 904;
   GLUT_VIDEO_RESIZE_HEIGHT_DELTA : constant := 905;
   GLUT_VIDEO_RESIZE_X            : constant := 906;
   GLUT_VIDEO_RESIZE_Y            : constant := 907;
   GLUT_VIDEO_RESIZE_WIDTH        : constant := 908;
   GLUT_VIDEO_RESIZE_HEIGHT       : constant := 909;

   --  glutUseLayer parameters.
   --  glutGetModifiers return mask.

   GLUT_ACTIVE_SHIFT               : constant := 1;
   GLUT_ACTIVE_CTRL                : constant := 2;
   GLUT_ACTIVE_ALT                 : constant := 4;

   --  glutSetCursor parameters.
   --  Basic arrows.

   GLUT_CURSOR_RIGHT_ARROW         : constant := 0;
   GLUT_CURSOR_LEFT_ARROW          : constant := 1;

   --  Symbolic cursor shapes.

   GLUT_CURSOR_INFO                : constant := 2;
   GLUT_CURSOR_DESTROY             : constant := 3;
   GLUT_CURSOR_HELP                : constant := 4;
   GLUT_CURSOR_CYCLE               : constant := 5;
   GLUT_CURSOR_SPRAY               : constant := 6;
   GLUT_CURSOR_WAIT                : constant := 7;
   GLUT_CURSOR_TEXT                : constant := 8;
   GLUT_CURSOR_CROSSHAIR           : constant := 9;

   --  Directional cursors.

   GLUT_CURSOR_UP_DOWN             : constant := 10;
   GLUT_CURSOR_LEFT_RIGHT          : constant := 11;

   --  Sizing cursors.

   GLUT_CURSOR_TOP_SIDE            : constant := 12;
   GLUT_CURSOR_BOTTOM_SIDE         : constant := 13;
   GLUT_CURSOR_LEFT_SIDE           : constant := 14;
   GLUT_CURSOR_RIGHT_SIDE          : constant := 15;
   GLUT_CURSOR_TOP_LEFT_CORNER     : constant := 16;
   GLUT_CURSOR_TOP_RIGHT_CORNER    : constant := 17;
   GLUT_CURSOR_BOTTOM_RIGHT_CORNER : constant := 18;
   GLUT_CURSOR_BOTTOM_LEFT_CORNER  : constant := 19;

   --  Inherit from parent window.

   GLUT_CURSOR_INHERIT             : constant := 100;

   --  Blank cursor.

   GLUT_CURSOR_NONE                : constant := 101;

   --  Fullscreen crosshair (if available).

   GLUT_CURSOR_FULL_CROSSHAIR      : constant := 102;

   --  GLUT initialization sub-API.

   procedure glutInit (argcp : access Integer;
                       argv  : access Interfaces.C.Strings.Chars_Ptr);

#IF GNAT_WIN then
   pragma Import (DLL, glutInit, "glutInit", "glutInit");
#ELSE
   pragma Import (C, glutInit, "glutInit", "glutInit");
#END IF;

   procedure glutInitDisplayMode (mode : Interfaces.C.unsigned);
#IF GNAT_WIN then
   pragma Import (DLL,
                  glutInitDisplayMode,
                  "glutInitDisplayMode",
                  "glutInitDisplayMode");
#ELSE
   pragma Import (C,
                  glutInitDisplayMode,
                  "glutInitDisplayMode",
                  "glutInitDisplayMode");
#END IF;

   procedure glutInitDisplayString (string : Interfaces.C.Strings.Chars_Ptr);
#IF GNAT_WIN then
   pragma Import (DLL,
                  glutInitDisplayString,
                  "glutInitDisplayString",
                  "glutInitDisplayString");
#ELSE
   pragma Import (C,
                  glutInitDisplayString,
                  "glutInitDisplayString",
                  "glutInitDisplayString");
#END IF;

   procedure glutInitWindowPosition (x : Integer; y : Integer);
#IF GNAT_WIN then
   pragma Import (DLL,
                  glutInitWindowPosition,
                  "glutInitWindowPosition",
                  "glutInitWindowPosition");
#ELSE
   pragma Import (C,
                  glutInitWindowPosition,
                  "glutInitWindowPosition",
                  "glutInitWindowPosition");
#END IF;

   procedure glutInitWindowSize (width : Integer; height : Integer);
#IF GNAT_WIN then
   pragma Import (DLL,
                  glutInitWindowSize,
                  "glutInitWindowSize",
                  "glutInitWindowSize");
#ELSE
   pragma Import (C,
                  glutInitWindowSize,
                  "glutInitWindowSize",
                  "glutInitWindowSize");
#END IF;

   procedure glutMainLoop;
#IF GNAT_WIN then
   pragma Import (DLL, glutMainLoop, "glutMainLoop", "glutMainLoop");
#ELSE
   pragma Import (C, glutMainLoop, "glutMainLoop", "glutMainLoop");
#END IF;

   --  GLUT window sub-API.

   function glutCreateWindow
      (title : Interfaces.C.Strings.Chars_Ptr) return Integer;
#IF GNAT_WIN then
   pragma Import (DLL, glutCreateWindow, "glutCreateWindow", "glutCreateWindow");
#ELSE
   pragma Import (C, glutCreateWindow, "glutCreateWindow", "glutCreateWindow");
#END IF;

   function glutCreateWindow (title : String) return Integer;

   function glutCreateSubWindow (win    : Integer;
                                 x      : Integer;
                                 y      : Integer;
                                 width  : Integer;
                                 height : Integer) return Integer;
#IF GNAT_WIN then
   pragma Import (DLL,
                  glutCreateSubWindow,
                  "glutCreateSubWindow",
                  "glutCreateSubWindow");
#ELSE
   pragma Import (C,
                  glutCreateSubWindow,
                  "glutCreateSubWindow",
                  "glutCreateSubWindow");
#END IF;

   procedure glutDestroyWindow (win : Integer);
#IF GNAT_WIN then
   pragma Import (DLL,
                  glutDestroyWindow,
                  "glutDestroyWindow",
                  "glutDestroyWindow");
#ELSE
   pragma Import (C,
                  glutDestroyWindow,
                  "glutDestroyWindow",
                  "glutDestroyWindow");
#END IF;

   procedure glutPostRedisplay;
#IF GNAT_WIN then
   pragma Import (DLL,
                  glutPostRedisplay,
                  "glutPostRedisplay",
                  "glutPostRedisplay");
#ELSE
   pragma Import (C,
                  glutPostRedisplay,
                  "glutPostRedisplay",
                  "glutPostRedisplay");
#END IF;

   procedure glutPostWindowRedisplay (win : Integer);
#IF GNAT_WIN then
   pragma Import (DLL,
                  glutPostWindowRedisplay,
                  "glutPostWindowRedisplay",
                  "glutPostWindowRedisplay");
#ELSE
   pragma Import (C,
                  glutPostWindowRedisplay,
                  "glutPostWindowRedisplay",
                  "glutPostWindowRedisplay");
#END IF;

   procedure glutSwapBuffers;
#IF GNAT_WIN then
   pragma Import (DLL, glutSwapBuffers, "glutSwapBuffers", "glutSwapBuffers");
#ELSE
   pragma Import (C, glutSwapBuffers, "glutSwapBuffers", "glutSwapBuffers");
#END IF;

   function glutGetWindow return Integer;
#IF GNAT_WIN then
   pragma Import (DLL, glutGetWindow, "glutGetWindow", "glutGetWindow");
#ELSE
   pragma Import (C, glutGetWindow, "glutGetWindow", "glutGetWindow");
#END IF;

   procedure glutSetWindow (win : Integer);
#IF GNAT_WIN then
   pragma Import (DLL, glutSetWindow, "glutSetWindow", "glutSetWindow");
#ELSE
   pragma Import (C, glutSetWindow, "glutSetWindow", "glutSetWindow");
#END IF;

   procedure glutSetWindowTitle (title : Interfaces.C.Strings.Chars_Ptr);
#IF GNAT_WIN then
   pragma Import (DLL,
                  glutSetWindowTitle,
                  "glutSetWindowTitle",
                  "glutSetWindowTitle");
#ELSE
   pragma Import (C,
                  glutSetWindowTitle,
                  "glutSetWindowTitle",
                  "glutSetWindowTitle");
#END IF;

   procedure glutSetWindowTitle (title : String);

   procedure glutSetIconTitle (title : Interfaces.C.Strings.Chars_Ptr);
#IF GNAT_WIN then
   pragma Import (DLL, glutSetIconTitle, "glutSetIconTitle", "glutSetIconTitle");
#ELSE
   pragma Import (C, glutSetIconTitle, "glutSetIconTitle", "glutSetIconTitle");
#END IF;

   procedure glutSetIconTitle (title : String);

   procedure glutPositionWindow (x : Integer; y : Integer);
#IF GNAT_WIN then
   pragma Import (DLL,
                  glutPositionWindow,
                  "glutPositionWindow",
                  "glutPositionWindow");
#ELSE
   pragma Import (C,
                  glutPositionWindow,
                  "glutPositionWindow",
                  "glutPositionWindow");
#END IF;

   procedure glutReshapeWindow (width : Integer; height : Integer);
#IF GNAT_WIN then
   pragma Import (DLL,
                  glutReshapeWindow,
                  "glutReshapeWindow",
                  "glutReshapeWindow");
#ELSE
   pragma Import (C,
                  glutReshapeWindow,
                  "glutReshapeWindow",
                  "glutReshapeWindow");
#END IF;

   procedure glutPopWindow;
#IF GNAT_WIN then
   pragma Import (DLL, glutPopWindow, "glutPopWindow", "glutPopWindow");
#ELSE
   pragma Import (C, glutPopWindow, "glutPopWindow", "glutPopWindow");
#END IF;

   procedure glutPushWindow;
#IF GNAT_WIN then
   pragma Import (DLL, glutPushWindow, "glutPushWindow", "glutPushWindow");
#ELSE
   pragma Import (C, glutPushWindow, "glutPushWindow", "glutPushWindow");
#END IF;

   procedure glutIconifyWindow;
#IF GNAT_WIN then
   pragma Import (DLL,
                  glutIconifyWindow,
                  "glutIconifyWindow",
                  "glutIconifyWindow");
#ELSE
   pragma Import (C,
                  glutIconifyWindow,
                  "glutIconifyWindow",
                  "glutIconifyWindow");
#END IF;

   procedure glutShowWindow;
#IF GNAT_WIN then
   pragma Import (DLL, glutShowWindow, "glutShowWindow", "glutShowWindow");
#ELSE
   pragma Import (C, glutShowWindow, "glutShowWindow", "glutShowWindow");
#END IF;

   procedure glutHideWindow;
#IF GNAT_WIN then
   pragma Import (DLL, glutHideWindow, "glutHideWindow", "glutHideWindow");
#ELSE
   pragma Import (C, glutHideWindow, "glutHideWindow", "glutHideWindow");
#END IF;

   procedure glutFullScreen;
#IF GNAT_WIN then
   pragma Import (DLL, glutFullScreen, "glutFullScreen", "glutFullScreen");
#ELSE
   pragma Import (C, glutFullScreen, "glutFullScreen", "glutFullScreen");
#END IF;

   procedure glutSetCursor (cursor : Integer);
#IF GNAT_WIN then
   pragma Import (DLL, glutSetCursor, "glutSetCursor", "glutSetCursor");
#ELSE
   pragma Import (C, glutSetCursor, "glutSetCursor", "glutSetCursor");
#END IF;

   procedure glutWarpPointer (x : Integer; y : Integer);
#IF GNAT_WIN then
   pragma Import (DLL, glutWarpPointer, "glutWarpPointer", "glutWarpPointer");
#ELSE
   pragma Import (C, glutWarpPointer, "glutWarpPointer", "glutWarpPointer");
#END IF;

   --  GLUT overlay sub-API.

   procedure glutEstablishOverlay;
#IF GNAT_WIN then
   pragma Import (DLL,
                  glutEstablishOverlay,
                  "glutEstablishOverlay",
                  "glutEstablishOverlay");
#ELSE
   pragma Import (C,
                  glutEstablishOverlay,
                  "glutEstablishOverlay",
                  "glutEstablishOverlay");
#END IF;

   procedure glutRemoveOverlay;
#IF GNAT_WIN then
   pragma Import (DLL,
                  glutRemoveOverlay,
                  "glutRemoveOverlay",
                  "glutRemoveOverlay");
#ELSE
   pragma Import (C,
                  glutRemoveOverlay,
                  "glutRemoveOverlay",
                  "glutRemoveOverlay");
#END IF;

   procedure glutUseLayer (layer : GLenum);
#IF GNAT_WIN then
   pragma Import (DLL, glutUseLayer, "glutUseLayer", "glutUseLayer");
#ELSE
   pragma Import (C, glutUseLayer, "glutUseLayer", "glutUseLayer");
#END IF;

   procedure glutPostOverlayRedisplay;
#IF GNAT_WIN then
   pragma Import (DLL,
                  glutPostOverlayRedisplay,
                  "glutPostOverlayRedisplay",
                  "glutPostOverlayRedisplay");
#ELSE
   pragma Import (C,
                  glutPostOverlayRedisplay,
                  "glutPostOverlayRedisplay",
                  "glutPostOverlayRedisplay");
#END IF;

   procedure glutPostWindowOverlayRedisplay (win : Integer);
#IF GNAT_WIN then
   pragma Import (DLL,
                  glutPostWindowOverlayRedisplay,
                  "glutPostWindowOverlayRedisplay",
                  "glutPostWindowOverlayRedisplay");
#ELSE
   pragma Import (C,
                  glutPostWindowOverlayRedisplay,
                  "glutPostWindowOverlayRedisplay",
                  "glutPostWindowOverlayRedisplay");
#END IF;

   procedure glutShowOverlay;
#IF GNAT_WIN then
   pragma Import (DLL, glutShowOverlay, "glutShowOverlay", "glutShowOverlay");
#ELSE
   pragma Import (C, glutShowOverlay, "glutShowOverlay", "glutShowOverlay");
#END IF;

   procedure glutHideOverlay;
#IF GNAT_WIN then
   pragma Import (DLL, glutHideOverlay, "glutHideOverlay", "glutHideOverlay");
#ELSE
   pragma Import (C, glutHideOverlay, "glutHideOverlay", "glutHideOverlay");
#END IF;

   --  GLUT menu sub-API.

   type Glut_proc_1 is access procedure (P1 : Integer);

   function glutCreateMenu (P1 : Glut_proc_1) return Integer;
#IF GNAT_WIN then
   pragma Import (DLL, glutCreateMenu, "glutCreateMenu", "glutCreateMenu");
#ELSE
   pragma Import (C, glutCreateMenu, "glutCreateMenu", "glutCreateMenu");
#END IF;

   procedure glutDestroyMenu (menu : Integer);
#IF GNAT_WIN then
   pragma Import (DLL, glutDestroyMenu, "glutDestroyMenu", "glutDestroyMenu");
#ELSE
   pragma Import (C, glutDestroyMenu, "glutDestroyMenu", "glutDestroyMenu");
#END IF;

   function glutGetMenu return Integer;
#IF GNAT_WIN then
   pragma Import (DLL, glutGetMenu, "glutGetMenu", "glutGetMenu");
#ELSE
   pragma Import (C, glutGetMenu, "glutGetMenu", "glutGetMenu");
#END IF;

   procedure glutSetMenu (menu : Integer);
#IF GNAT_WIN then
   pragma Import (DLL, glutSetMenu, "glutSetMenu", "glutSetMenu");
#ELSE
   pragma Import (C, glutSetMenu, "glutSetMenu", "glutSetMenu");
#END IF;

   procedure glutAddMenuEntry (label : Interfaces.C.Strings.Chars_Ptr;
                               value : Integer);
#IF GNAT_WIN then
   pragma Import (DLL, glutAddMenuEntry, "glutAddMenuEntry", "glutAddMenuEntry");
#ELSE
   pragma Import (C, glutAddMenuEntry, "glutAddMenuEntry", "glutAddMenuEntry");
#END IF;

   procedure glutAddMenuEntry (label : String; value : Integer);

   procedure glutAddSubMenu (label   : Interfaces.C.Strings.Chars_Ptr;
                             submenu : Integer);
#IF GNAT_WIN then
   pragma Import (DLL, glutAddSubMenu, "glutAddSubMenu", "glutAddSubMenu");
#ELSE
   pragma Import (C, glutAddSubMenu, "glutAddSubMenu", "glutAddSubMenu");
#END IF;

   procedure glutAddSubMenu (label : String; submenu : Integer);

   procedure glutChangeToMenuEntry (item  : Integer;
                                    label : Interfaces.C.Strings.Chars_Ptr;
                                    value : Integer);
#IF GNAT_WIN then
   pragma Import (DLL,
                  glutChangeToMenuEntry,
                  "glutChangeToMenuEntry",
                  "glutChangeToMenuEntry");
#ELSE
   pragma Import (C,
                  glutChangeToMenuEntry,
                  "glutChangeToMenuEntry",
                  "glutChangeToMenuEntry");
#END IF;

   procedure glutChangeToMenuEntry (item  : Integer;
                                    label : String;
                                    value : Integer);

   procedure glutChangeToSubMenu (item    : Integer;
                                  label   : Interfaces.C.Strings.Chars_Ptr;
                                  submenu : Integer);
#IF GNAT_WIN then
   pragma Import (DLL,
                  glutChangeToSubMenu,
                  "glutChangeToSubMenu",
                  "glutChangeToSubMenu");
#ELSE
   pragma Import (C,
                  glutChangeToSubMenu,
                  "glutChangeToSubMenu",
                  "glutChangeToSubMenu");
#END IF;

   procedure glutChangeToSubMenu (item    : Integer;
                                  label   : String;
                                  submenu : Integer);

   procedure glutRemoveMenuItem (item : Integer);
#IF GNAT_WIN then
   pragma Import (DLL,
                  glutRemoveMenuItem,
                  "glutRemoveMenuItem",
                  "glutRemoveMenuItem");
#ELSE
   pragma Import (C,
                  glutRemoveMenuItem,
                  "glutRemoveMenuItem",
                  "glutRemoveMenuItem");
#END IF;

   procedure glutAttachMenu (button : Integer);
#IF GNAT_WIN then
   pragma Import (DLL, glutAttachMenu, "glutAttachMenu", "glutAttachMenu");
#ELSE
   pragma Import (C, glutAttachMenu, "glutAttachMenu", "glutAttachMenu");
#END IF;

   procedure glutDetachMenu (button : Integer);
#IF GNAT_WIN then
   pragma Import (DLL, glutDetachMenu, "glutDetachMenu", "glutDetachMenu");
#ELSE
   pragma Import (C, glutDetachMenu, "glutDetachMenu", "glutDetachMenu");
#END IF;

   --  GLUT callback sub-API.

   type Glut_proc_2 is access procedure;

   procedure glutDisplayFunc (P1 : Glut_proc_2);
#IF GNAT_WIN then
   pragma Import (DLL, glutDisplayFunc, "glutDisplayFunc", "glutDisplayFunc");
#ELSE
   pragma Import (C, glutDisplayFunc, "glutDisplayFunc", "glutDisplayFunc");
#END IF;

   type Glut_proc_3 is access procedure (width : Integer; height : Integer);

   procedure glutReshapeFunc (P1 : Glut_proc_3);
#IF GNAT_WIN then
   pragma Import (DLL, glutReshapeFunc, "glutReshapeFunc", "glutReshapeFunc");
#ELSE
   pragma Import (C, glutReshapeFunc, "glutReshapeFunc", "glutReshapeFunc");
#END IF;

   type Glut_proc_4 is access
      procedure (key : Interfaces.C.unsigned_char; x : Integer; y : Integer);

   procedure glutKeyboardFunc (P1 : Glut_proc_4);
#IF GNAT_WIN then
   pragma Import (DLL, glutKeyboardFunc, "glutKeyboardFunc", "glutKeyboardFunc");
#ELSE
   pragma Import (C, glutKeyboardFunc, "glutKeyboardFunc", "glutKeyboardFunc");
#END IF;

   type Glut_proc_5 is access
      procedure (button : Integer; state : Integer; x : Integer; y : Integer);

   procedure glutMouseFunc (P1 : Glut_proc_5);
#IF GNAT_WIN then
   pragma Import (DLL, glutMouseFunc, "glutMouseFunc", "glutMouseFunc");
#ELSE
   pragma Import (C, glutMouseFunc, "glutMouseFunc", "glutMouseFunc");
#END IF;

   type Glut_proc_6 is access procedure (x : Integer; y : Integer);

   procedure glutMotionFunc (P1 : Glut_proc_6);
#IF GNAT_WIN then
   pragma Import (DLL, glutMotionFunc, "glutMotionFunc", "glutMotionFunc");
#ELSE
   pragma Import (C, glutMotionFunc, "glutMotionFunc", "glutMotionFunc");
#END IF;

   type Glut_proc_7 is access procedure (x : Integer; y : Integer);

   procedure glutPassiveMotionFunc (P1 : Glut_proc_7);
#IF GNAT_WIN then
   pragma Import (DLL,
                  glutPassiveMotionFunc,
                  "glutPassiveMotionFunc",
                  "glutPassiveMotionFunc");
#ELSE
   pragma Import (C,
                  glutPassiveMotionFunc,
                  "glutPassiveMotionFunc",
                  "glutPassiveMotionFunc");
#END IF;

   type Glut_proc_8 is access procedure (state : Integer);

   procedure glutEntryFunc (P1 : Glut_proc_8);
#IF GNAT_WIN then
   pragma Import (DLL, glutEntryFunc, "glutEntryFunc", "glutEntryFunc");
#ELSE
   pragma Import (C, glutEntryFunc, "glutEntryFunc", "glutEntryFunc");
#END IF;

   type Glut_proc_9 is access procedure (state : Integer);

   procedure glutVisibilityFunc (P1 : Glut_proc_9);
#IF GNAT_WIN then
   pragma Import (DLL,
                  glutVisibilityFunc,
                  "glutVisibilityFunc",
                  "glutVisibilityFunc");
#ELSE
   pragma Import (C,
                  glutVisibilityFunc,
                  "glutVisibilityFunc",
                  "glutVisibilityFunc");
#END IF;

   type Glut_proc_10 is access procedure;

   procedure glutIdleFunc (P1 : Glut_proc_10);
#IF GNAT_WIN then
   pragma Import (DLL, glutIdleFunc, "glutIdleFunc", "glutIdleFunc");
#ELSE
   pragma Import (C, glutIdleFunc, "glutIdleFunc", "glutIdleFunc");
#END IF;

   type Glut_proc_11 is access procedure (value : Integer);

   procedure glutTimerFunc (millis : Interfaces.C.unsigned;
                            P2     : Glut_proc_11;
                            value  : Integer);
#IF GNAT_WIN then
   pragma Import (DLL, glutTimerFunc, "glutTimerFunc", "glutTimerFunc");
#ELSE
   pragma Import (C, glutTimerFunc, "glutTimerFunc", "glutTimerFunc");
#END IF;

   type Glut_proc_12 is access procedure (state : Integer);

   procedure glutMenuStateFunc (P1 : Glut_proc_12);
#IF GNAT_WIN then
   pragma Import (DLL,
                  glutMenuStateFunc,
                  "glutMenuStateFunc",
                  "glutMenuStateFunc");
#ELSE
   pragma Import (C,
                  glutMenuStateFunc,
                  "glutMenuStateFunc",
                  "glutMenuStateFunc");
#END IF;

   type Glut_proc_13 is access
      procedure (key : Integer; x : Integer; y : Integer);

   procedure glutSpecialFunc (P1 : Glut_proc_13);
#IF GNAT_WIN then
   pragma Import (DLL, glutSpecialFunc, "glutSpecialFunc", "glutSpecialFunc");
#ELSE
   pragma Import (C, glutSpecialFunc, "glutSpecialFunc", "glutSpecialFunc");
#END IF;

   type Glut_proc_14 is access
      procedure (x : Integer; y : Integer; z : Integer);

   procedure glutSpaceballMotionFunc (P1 : Glut_proc_14);
#IF GNAT_WIN then
   pragma Import (DLL,
                  glutSpaceballMotionFunc,
                  "glutSpaceballMotionFunc",
                  "glutSpaceballMotionFunc");
#ELSE
   pragma Import (C,
                  glutSpaceballMotionFunc,
                  "glutSpaceballMotionFunc",
                  "glutSpaceballMotionFunc");
#END IF;

   type Glut_proc_15 is access
      procedure (x : Integer; y : Integer; z : Integer);

   procedure glutSpaceballRotateFunc (P1 : Glut_proc_15);
#IF GNAT_WIN then
   pragma Import (DLL,
                  glutSpaceballRotateFunc,
                  "glutSpaceballRotateFunc",
                  "glutSpaceballRotateFunc");
#ELSE
   pragma Import (C,
                  glutSpaceballRotateFunc,
                  "glutSpaceballRotateFunc",
                  "glutSpaceballRotateFunc");
#END IF;

   type Glut_proc_16 is access procedure (button : Integer; state : Integer);

   procedure glutSpaceballButtonFunc (P1 : Glut_proc_16);
#IF GNAT_WIN then
   pragma Import (DLL,
                  glutSpaceballButtonFunc,
                  "glutSpaceballButtonFunc",
                  "glutSpaceballButtonFunc");
#ELSE
   pragma Import (C,
                  glutSpaceballButtonFunc,
                  "glutSpaceballButtonFunc",
                  "glutSpaceballButtonFunc");
#END IF;

   type Glut_proc_17 is access procedure (button : Integer; state : Integer);

   procedure glutButtonBoxFunc (P1 : Glut_proc_17);
#IF GNAT_WIN then
   pragma Import (DLL,
                  glutButtonBoxFunc,
                  "glutButtonBoxFunc",
                  "glutButtonBoxFunc");
#ELSE
   pragma Import (C,
                  glutButtonBoxFunc,
                  "glutButtonBoxFunc",
                  "glutButtonBoxFunc");
#END IF;

   type Glut_proc_18 is access procedure (dial : Integer; value : Integer);

   procedure glutDialsFunc (P1 : Glut_proc_18);
#IF GNAT_WIN then
   pragma Import (DLL, glutDialsFunc, "glutDialsFunc", "glutDialsFunc");
#ELSE
   pragma Import (C, glutDialsFunc, "glutDialsFunc", "glutDialsFunc");
#END IF;

   type Glut_proc_19 is access procedure (x : Integer; y : Integer);

   procedure glutTabletMotionFunc (P1 : Glut_proc_19);
#IF GNAT_WIN then
   pragma Import (DLL,
                  glutTabletMotionFunc,
                  "glutTabletMotionFunc",
                  "glutTabletMotionFunc");
#ELSE
   pragma Import (C,
                  glutTabletMotionFunc,
                  "glutTabletMotionFunc",
                  "glutTabletMotionFunc");
#END IF;

   type Glut_proc_20 is access
      procedure (button : Integer; state : Integer; x : Integer; y : Integer);

   procedure glutTabletButtonFunc (P1 : Glut_proc_20);
#IF GNAT_WIN then
   pragma Import (DLL,
                  glutTabletButtonFunc,
                  "glutTabletButtonFunc",
                  "glutTabletButtonFunc");
#ELSE
   pragma Import (C,
                  glutTabletButtonFunc,
                  "glutTabletButtonFunc",
                  "glutTabletButtonFunc");
#END IF;

   type Glut_proc_21 is access
      procedure (status : Integer; x : Integer; y : Integer);

   procedure glutMenuStatusFunc (P1 : Glut_proc_21);
#IF GNAT_WIN then
   pragma Import (DLL,
                  glutMenuStatusFunc,
                  "glutMenuStatusFunc",
                  "glutMenuStatusFunc");
#ELSE
   pragma Import (C,
                  glutMenuStatusFunc,
                  "glutMenuStatusFunc",
                  "glutMenuStatusFunc");
#END IF;

   type Glut_proc_22 is access procedure;

   procedure glutOverlayDisplayFunc (P1 : Glut_proc_22);
#IF GNAT_WIN then
   pragma Import (DLL,
                  glutOverlayDisplayFunc,
                  "glutOverlayDisplayFunc",
                  "glutOverlayDisplayFunc");
#ELSE
   pragma Import (C,
                  glutOverlayDisplayFunc,
                  "glutOverlayDisplayFunc",
                  "glutOverlayDisplayFunc");
#END IF;

   type Glut_proc_23 is access procedure (state : Integer);

   procedure glutWindowStatusFunc (P1 : Glut_proc_23);
#IF GNAT_WIN then
   pragma Import (DLL,
                  glutWindowStatusFunc,
                  "glutWindowStatusFunc",
                  "glutWindowStatusFunc");
#ELSE
   pragma Import (C,
                  glutWindowStatusFunc,
                  "glutWindowStatusFunc",
                  "glutWindowStatusFunc");
#END IF;

   --  GLUT color index sub-API.

   procedure glutSetColor (P1    : Integer;
                           red   : GLfloat;
                           green : GLfloat;
                           blue  : GLfloat);
#IF GNAT_WIN then
   pragma Import (DLL, glutSetColor, "glutSetColor", "glutSetColor");
#ELSE
   pragma Import (C, glutSetColor, "glutSetColor", "glutSetColor");
#END IF;

   function glutGetColor
      (ndx : Integer; component : Integer) return GLfloat;
#IF GNAT_WIN then
   pragma Import (DLL, glutGetColor, "glutGetColor", "glutGetColor");
#ELSE
   pragma Import (C, glutGetColor, "glutGetColor", "glutGetColor");
#END IF;

   procedure glutCopyColormap (win : Integer);
#IF GNAT_WIN then
   pragma Import (DLL, glutCopyColormap, "glutCopyColormap", "glutCopyColormap");
#ELSE
   pragma Import (C, glutCopyColormap, "glutCopyColormap", "glutCopyColormap");
#END IF;

   --  GLUT state retrieval sub-API.

   function glutGet (type_Id : GLenum) return Integer;
#IF GNAT_WIN then
   pragma Import (DLL, glutGet, "glutGet", "glutGet");
#ELSE
   pragma Import (C, glutGet, "glutGet", "glutGet");
#END IF;

   function glutDeviceGet (type_Id : GLenum) return Integer;
#IF GNAT_WIN then
   pragma Import (DLL, glutDeviceGet, "glutDeviceGet", "glutDeviceGet");
#ELSE
   pragma Import (C, glutDeviceGet, "glutDeviceGet", "glutDeviceGet");
#END IF;

   --  GLUT extension support sub-API

   function glutExtensionSupported
      (name : Interfaces.C.Strings.Chars_Ptr) return Integer;
#IF GNAT_WIN then
   pragma Import (DLL,
                  glutExtensionSupported,
                  "glutExtensionSupported",
                  "glutExtensionSupported");
#ELSE
   pragma Import (C,
                  glutExtensionSupported,
                  "glutExtensionSupported",
                  "glutExtensionSupported");
#END IF;

   function glutExtensionSupported (name : String) return Integer;

   function glutGetModifiers return Integer;
#IF GNAT_WIN then
   pragma Import (DLL, glutGetModifiers, "glutGetModifiers", "glutGetModifiers");
#ELSE
   pragma Import (C, glutGetModifiers, "glutGetModifiers", "glutGetModifiers");
#END IF;

   function glutLayerGet (type_Id : GLenum) return Integer;
#IF GNAT_WIN then
   pragma Import (DLL, glutLayerGet, "glutLayerGet", "glutLayerGet");
#ELSE
   pragma Import (C, glutLayerGet, "glutLayerGet", "glutLayerGet");
#END IF;

   --  GLUT font sub-API

   procedure glutBitmapCharacter (font      : access Interfaces.C.Extensions.Void_Ptr;
                                  character : Integer);
#IF GNAT_WIN then
   pragma Import (DLL,
                  glutBitmapCharacter,
                  "glutBitmapCharacter",
                  "glutBitmapCharacter");
#ELSE
   pragma Import (C,
                  glutBitmapCharacter,
                  "glutBitmapCharacter",
                  "glutBitmapCharacter");
#END IF;

   function glutBitmapWidth
      (font      : access Interfaces.C.Extensions.Void_Ptr;
       character : Integer) return Integer;
#IF GNAT_WIN then
   pragma Import (DLL, glutBitmapWidth, "glutBitmapWidth", "glutBitmapWidth");
#ELSE
   pragma Import (C, glutBitmapWidth, "glutBitmapWidth", "glutBitmapWidth");
#END IF;

   procedure glutStrokeCharacter
      (font      : access Interfaces.C.Extensions.Void_Ptr;
       character : Integer);
#IF GNAT_WIN then
   pragma Import (DLL,
                  glutStrokeCharacter,
                  "glutStrokeCharacter",
                  "glutStrokeCharacter");
#ELSE
   pragma Import (C,
                  glutStrokeCharacter,
                  "glutStrokeCharacter",
                  "glutStrokeCharacter");
#END IF;

   function glutStrokeWidth
      (font      : access Interfaces.C.Extensions.Void_Ptr;
       character : Integer) return Integer;
#IF GNAT_WIN then
   pragma Import (DLL, glutStrokeWidth, "glutStrokeWidth", "glutStrokeWidth");
#ELSE
   pragma Import (C, glutStrokeWidth, "glutStrokeWidth", "glutStrokeWidth");
#END IF;

   function glutStrokeLength
      (font      : access Interfaces.C.Extensions.Void_Ptr;
       string    : Interfaces.C.Strings.Chars_Ptr) return Integer;
#IF GNAT_WIN then
   pragma Import (DLL, glutStrokeLength, "glutStrokeLength", "glutStrokeLength");
#ELSE
   pragma Import (C, glutStrokeLength, "glutStrokeLength", "glutStrokeLength");
#END IF;

   function glutBitmapLength
      (font      : access Interfaces.C.Extensions.Void_Ptr;
       string    : Interfaces.C.Strings.Chars_Ptr) return Integer;
#IF GNAT_WIN then
   pragma Import (DLL, glutBitmapLength, "glutBitmapLength", "glutBitmapLength");
#ELSE
   pragma Import (C, glutBitmapLength, "glutBitmapLength", "glutBitmapLength");
#END IF;

   --  GLUT pre-built models sub-API

   procedure glutWireSphere (radius : GLdouble;
                             slices : GLint;
                             stacks : GLint);
#IF GNAT_WIN then
   pragma Import (DLL, glutWireSphere, "glutWireSphere", "glutWireSphere");
#ELSE
   pragma Import (C, glutWireSphere, "glutWireSphere", "glutWireSphere");
#END IF;

   procedure glutSolidSphere (radius : GLdouble;
                              slices : GLint;
                              stacks : GLint);
#IF GNAT_WIN then
   pragma Import (DLL, glutSolidSphere, "glutSolidSphere", "glutSolidSphere");
#ELSE
   pragma Import (C, glutSolidSphere, "glutSolidSphere", "glutSolidSphere");
#END IF;

   procedure glutWireCone (base   : GLdouble;
                           height : GLdouble;
                           slices : GLint;
                           stacks : GLint);
#IF GNAT_WIN then
   pragma Import (DLL, glutWireCone, "glutWireCone", "glutWireCone");
#ELSE
   pragma Import (C, glutWireCone, "glutWireCone", "glutWireCone");
#END IF;

   procedure glutSolidCone (base   : GLdouble;
                            height : GLdouble;
                            slices : GLint;
                            stacks : GLint);
#IF GNAT_WIN then
   pragma Import (DLL, glutSolidCone, "glutSolidCone", "glutSolidCone");
#ELSE
   pragma Import (C, glutSolidCone, "glutSolidCone", "glutSolidCone");
#END IF;

   procedure glutWireCube (size : GLdouble);
#IF GNAT_WIN then
   pragma Import (DLL, glutWireCube, "glutWireCube", "glutWireCube");
#ELSE
   pragma Import (C, glutWireCube, "glutWireCube", "glutWireCube");
#END IF;

   procedure glutSolidCube (size : GLdouble);
#IF GNAT_WIN then
   pragma Import (DLL, glutSolidCube, "glutSolidCube", "glutSolidCube");
#ELSE
   pragma Import (C, glutSolidCube, "glutSolidCube", "glutSolidCube");
#END IF;

   procedure glutWireTorus (innerRadius : GLdouble;
                            outerRadius : GLdouble;
                            sides       : GLint;
                            rings       : GLint);
#IF GNAT_WIN then
   pragma Import (DLL, glutWireTorus, "glutWireTorus", "glutWireTorus");
#ELSE
   pragma Import (C, glutWireTorus, "glutWireTorus", "glutWireTorus");
#END IF;

   procedure glutSolidTorus (innerRadius : GLdouble;
                             outerRadius : GLdouble;
                             sides       : GLint;
                             rings       : GLint);
#IF GNAT_WIN then
   pragma Import (DLL, glutSolidTorus, "glutSolidTorus", "glutSolidTorus");
#ELSE
   pragma Import (C, glutSolidTorus, "glutSolidTorus", "glutSolidTorus");
#END IF;

   procedure glutWireDodecahedron;
#IF GNAT_WIN then
   pragma Import (DLL,
                  glutWireDodecahedron,
                  "glutWireDodecahedron",
                  "glutWireDodecahedron");
#ELSE
   pragma Import (C,
                  glutWireDodecahedron,
                  "glutWireDodecahedron",
                  "glutWireDodecahedron");
#END IF;

   procedure glutSolidDodecahedron;
#IF GNAT_WIN then
   pragma Import (DLL,
                  glutSolidDodecahedron,
                  "glutSolidDodecahedron",
                  "glutSolidDodecahedron");
#ELSE
   pragma Import (C,
                  glutSolidDodecahedron,
                  "glutSolidDodecahedron",
                  "glutSolidDodecahedron");
#END IF;

   procedure glutWireTeapot (size : GLdouble);
#IF GNAT_WIN then
   pragma Import (DLL, glutWireTeapot, "glutWireTeapot", "glutWireTeapot");
#ELSE
   pragma Import (C, glutWireTeapot, "glutWireTeapot", "glutWireTeapot");
#END IF;

   procedure glutSolidTeapot (size : GLdouble);
#IF GNAT_WIN then
   pragma Import (DLL, glutSolidTeapot, "glutSolidTeapot", "glutSolidTeapot");
#ELSE
   pragma Import (C, glutSolidTeapot, "glutSolidTeapot", "glutSolidTeapot");
#END IF;

   procedure glutWireOctahedron;
#IF GNAT_WIN then
   pragma Import (DLL,
                  glutWireOctahedron,
                  "glutWireOctahedron",
                  "glutWireOctahedron");
#ELSE
   pragma Import (C,
                  glutWireOctahedron,
                  "glutWireOctahedron",
                  "glutWireOctahedron");
#END IF;

   procedure glutSolidOctahedron;
#IF GNAT_WIN then
   pragma Import (DLL,
                  glutSolidOctahedron,
                  "glutSolidOctahedron",
                  "glutSolidOctahedron");
#ELSE
   pragma Import (C,
                  glutSolidOctahedron,
                  "glutSolidOctahedron",
                  "glutSolidOctahedron");
#END IF;

   procedure glutWireTetrahedron;
#IF GNAT_WIN then
   pragma Import (DLL,
                  glutWireTetrahedron,
                  "glutWireTetrahedron",
                  "glutWireTetrahedron");
#ELSE
   pragma Import (C,
                  glutWireTetrahedron,
                  "glutWireTetrahedron",
                  "glutWireTetrahedron");
#END IF;

   procedure glutSolidTetrahedron;
#IF GNAT_WIN then
   pragma Import (DLL,
                  glutSolidTetrahedron,
                  "glutSolidTetrahedron",
                  "glutSolidTetrahedron");
#ELSE
   pragma Import (C,
                  glutSolidTetrahedron,
                  "glutSolidTetrahedron",
                  "glutSolidTetrahedron");
#END IF;

   procedure glutWireIcosahedron;
#IF GNAT_WIN then
   pragma Import (DLL,
                  glutWireIcosahedron,
                  "glutWireIcosahedron",
                  "glutWireIcosahedron");
#ELSE
   pragma Import (C,
                  glutWireIcosahedron,
                  "glutWireIcosahedron",
                  "glutWireIcosahedron");
#END IF;

   procedure glutSolidIcosahedron;
#IF GNAT_WIN then
   pragma Import (DLL,
                  glutSolidIcosahedron,
                  "glutSolidIcosahedron",
                  "glutSolidIcosahedron");
#ELSE
   pragma Import (C,
                  glutSolidIcosahedron,
                  "glutSolidIcosahedron",
                  "glutSolidIcosahedron");
#END IF;

   function glutVideoResizeGet (param : GLenum) return Integer;
#IF GNAT_WIN then
   pragma Import (DLL,
                  glutVideoResizeGet,
                  "glutVideoResizeGet",
                  "glutVideoResizeGet");
#ELSE
   pragma Import (C,
                  glutVideoResizeGet,
                  "glutVideoResizeGet",
                  "glutVideoResizeGet");
#END IF;

   procedure glutSetupVideoResizing;
#IF GNAT_WIN then
   pragma Import (DLL,
                  glutSetupVideoResizing,
                  "glutSetupVideoResizing",
                  "glutSetupVideoResizing");
#ELSE
   pragma Import (C,
                  glutSetupVideoResizing,
                  "glutSetupVideoResizing",
                  "glutSetupVideoResizing");
#END IF;

   procedure glutStopVideoResizing;
#IF GNAT_WIN then
   pragma Import (DLL,
                  glutStopVideoResizing,
                  "glutStopVideoResizing",
                  "glutStopVideoResizing");
#ELSE
   pragma Import (C,
                  glutStopVideoResizing,
                  "glutStopVideoResizing",
                  "glutStopVideoResizing");
#END IF;

   procedure glutVideoResize (x      : Integer;
                              y      : Integer;
                              width  : Integer;
                              height : Integer);
#IF GNAT_WIN then
   pragma Import (DLL, glutVideoResize, "glutVideoResize", "glutVideoResize");
#ELSE
   pragma Import (C, glutVideoResize, "glutVideoResize", "glutVideoResize");
#END IF;

   procedure glutVideoPan (x      : Integer;
                           y      : Integer;
                           width  : Integer;
                           height : Integer);
#IF GNAT_WIN then
   pragma Import (DLL, glutVideoPan, "glutVideoPan", "glutVideoPan");
#ELSE
   pragma Import (C, glutVideoPan, "glutVideoPan", "glutVideoPan");
#END IF;

end Glut_H;

