------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                         REFLECTION_CONTROLLERS                           --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.3 $                             --
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with MVC; use MVC;
with Main_Window_Pkg; use Main_Window_Pkg;

package Reflection_Controllers is
   type Reflection_Controller is new Controller_Obj with private;
   type Reflection_Controller_Ptr is access all Reflection_Controller'Class;

   --  Initialize controller from view
   procedure Initialize (C : access Reflection_Controller;
                         M : access Model_Obj'Class;
                         V : access View_Obj'Class);

   --  Update main window
   procedure Update_All (This : access Reflection_Controller);

private
   type Reflection_Controller is new Controller_Obj with record
      Window : Main_Window_Access;
   end record;

end Reflection_Controllers;
