------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                            REFLECTION_MODELS                             --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.3 $                             --
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

--  Model for date reflections
package body Reflection_Models is

   ---------------
   --  Queries  --
   ---------------

   --  Date of "Source" reflected around "Radix"
   function Reflection (This : access Reflection_Model) return Long_Float is
   begin
      return This.Radix_Jd - (This.Source_Jd - This.Radix_JD);
   end Reflection;


   -------------------------
   --  Basic Operations   --
   -------------------------

   procedure Update_All
     (This : access Reflection_Model;
      Evt : access Event'Class) is
   begin
      Notify_Observers (This, Evt);
   end Update_All;

   procedure Set_Radix
     (This : access Reflection_Model;
      Day : Days; Month : Months; Year : Years; UT : Long_Float) is
   begin
      This.Radix_JD :=
        Gregorian_To_Julian_Day (Day, Month, Year, UT);
   end Set_Radix;

   procedure Set_Source
     (This : access Reflection_Model;
      Day : Days; Month : Months; Year : Years; UT : Long_Float) is
   begin
      This.Source_JD :=
        Gregorian_To_Julian_Day (Day, Month, Year, UT);
   end Set_Source;

end Reflection_Models;

