------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                            REFLECTION_MODELS                             --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.3 $                             --
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with MVC; use MVC;
with Publish_Subscribe; use Publish_Subscribe;
with Times; use Times;

--  Model for date reflections
package Reflection_Models is
   type Reflection_Model is new Model_Obj with private;
   type Reflection_Model_Ptr is access all Reflection_Model'Class;

   ---------------
   --  Queries  --
   ---------------

   --  Date of "Source" reflected around "Radix"
   function Reflection (This : access Reflection_Model) return Long_Float;


   ------------------------
   --  Basic Operations  --
   ------------------------
   procedure Update_All
     (This : access Reflection_Model; Evt : access Event'Class);

   procedure Set_Radix
     (This : access Reflection_Model;
      Day : Days; Month : Months; Year : Years; UT : Long_Float);

   procedure Set_Source
     (This : access Reflection_Model;
      Day : Days; Month : Months; Year : Years; UT : Long_Float);

private
   type Reflection_Model is new Model_Obj with record
      Radix_JD, Source_JD : Long_Float;
   end record;

   pragma Inline (Reflection);
end Reflection_Models;
