------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                             REFLECTION_VIEWS                             --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.3 $                             --
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with Ada.Strings.Fixed, Ada.Strings.Maps.Constants;
use Ada.Strings, Ada.Strings.Fixed;
use Ada.Strings.Maps, Ada.Strings.Maps.Constants;

with Gtk.Label; use Gtk.Label;
with Times; use Times;
with Decimal_Sexagesimal; use Decimal_Sexagesimal;

with Reflection_Models; use Reflection_Models;

--  View for reflection window
package body Reflection_Views is

   ----------------------
   --  Initialization  --
   ----------------------

   procedure Initialize
     (This : access Reflection_View;
      M : access Model_Obj'Class)
   is
   begin
      --  Super initialization operation.  Handles MVC setup
      MVC.Initialize (View_Obj (This.all)'Access, M);
      Add_Observer (M, Observer (This.all)'Access);

      --  Create  main window and controller
      Gtk_New (This.Window);
      This.Controller := new Reflection_Controller;

      --  Initialize main window.  Controller reference allows
      --  GTK+ callbacks to dispatch to the controller for GUI event
      --  handling
      Main_Window_Pkg.Initialize
        (This.Window, Controller_Ptr'(This.Controller.all'Access));

      --  Initialize controller for window Event_List
      Reflection_Controllers.Initialize (This.Controller, M, This);

      --  Display main window
      Show_All (This.Window);
   end Initialize;


   ---------------
   --  Queries  --
   ---------------

   function Window (This : access Reflection_View) return Main_Window_Access is
   begin
      return This.Window;
   end Window;


   ------------------------
   --  Basic Operations  --
   ------------------------

   --  Update main window
   procedure Update
     (This: access Reflection_View;
      Source: access Observable'Class;
      Evt: access Event'Class) is
   begin
      if Source.all in Reflection_Model'Class then
         declare
            Model : Reflection_Model_Ptr :=
              Reflection_Model (Source.all)'Access;
            Reflected_Date : Long_Float := Reflection (Model);
         begin

            Set_Text (This.Window.Reflection_Day,
                      Days'Image (Day (Reflected_Date)) & " ");

            Set_Text (This.Window.Reflection_Month,
                      Months'Image (Month (Reflected_Date)) (1 .. 1) &
                                    Translate
                                    (Months'Image
                                     (Month (Reflected_Date)) (2 .. 3),
                                    Lower_Case_Map) & " ");

            Set_Text (This.Window.Reflection_Year,
                      Years'Image (Year (Reflected_Date)));

            Set_Text (This.Window.Reflection_Hour,
                      To_Time_String (JD_Hours (Reflected_Date)));
         end;
      end if;
   end Update;

end Reflection_Views;

