------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                             REFLECTION_VIEWS                             --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.3 $                             --
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with Mvc; use Mvc;
with Publish_Subscribe; use Publish_Subscribe;
with Reflection_Controllers; use Reflection_Controllers;
with Main_Window_Pkg; use Main_Window_Pkg;

--  View for reflection main window
package Reflection_Views is
   type Reflection_View is new View_Obj with private;

   --  Initialize view
   procedure Initialize (This : access Reflection_View;
                         M : access Model_Obj'Class);

   --  Reference to window associated with view
   function Window (This : access Reflection_View) return Main_Window_Access;

private
   -- Update main window
   procedure Update(
                    This: access Reflection_View;
                    Source: access Observable'Class;
                    Evt: access Event'Class);

   type Reflection_View is new View_Obj with record
      Controller : Reflection_Controller_Ptr;
      Window  : Main_Window_Access;
   end record;

   pragma Inline (Window);
end Reflection_Views;
