------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                        MAIN_WINDOW_PKG.CALLBACKS                         --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.3 $                             --
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with Gtk.Widget; use Gtk.Widget;
with Gtk.Main;

with Reflection_Controllers; use Reflection_Controllers;

--  Handle callbacks from reflection window
package body Main_Window_Pkg.Callbacks is

   use Gtk.Arguments;

   ---------------------------------
   -- On_Main_Window_Delete_Event --
   ---------------------------------

   function On_Main_Window_Delete_Event
     (Object : access Gtk_Widget_Record'Class;
      Params : Gtk.Arguments.Gtk_Args) return Boolean
   is
   begin
      --  Exit main GTK+ event loop
      Gtk.Main.Main_Quit;
      return True;
   end On_Main_Window_Delete_Event;

   ---------------------------------
   -- On_Calculate_Button_Clicked --
   ---------------------------------

   procedure On_Calculate_Button_Clicked
     (Object : access Gtk_Button_Record'Class;
      Controller : Controller_Ptr)
   is
   begin
      Update_All (Reflection_Controller (Controller.all)'Access);
   end On_Calculate_Button_Clicked;

end Main_Window_Pkg.Callbacks;
