------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                             MAIN_WINDOW_PKG                              --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.4 $                             --
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------
with Gtk; use Gtk;
with Gtk.Widget;      use Gtk.Widget;
with Gtk.Enums;       use Gtk.Enums;
with Gtkada.Handlers; use Gtkada.Handlers;
with Callbacks_Julian; use Callbacks_Julian;
with Julian_Intl; use Julian_Intl;
with Main_Window_Pkg.Callbacks; use Main_Window_Pkg.Callbacks;

--  Reflection program window
package body Main_Window_Pkg is

procedure Gtk_New (Main_Window : out Main_Window_Access) is
begin
   Main_Window := new Main_Window_Record;
end Gtk_New;

procedure Initialize
  (Main_Window : access Main_Window_Record'Class;
   Controller : Controller_Ptr) is
   pragma Suppress (All_Checks);
   Combo2_Items : String_List.Glist;
   Combo1_Items : String_List.Glist;

begin
   Gtk.Window.Initialize (Main_Window, Window_Toplevel);
   Return_Callback.Connect
     (Main_Window, "delete_event", On_Main_Window_Delete_Event'Access);
   Set_Title (Main_Window, -"AstroFrames: Reflected Date Calculator");
   Set_Policy (Main_Window, False, True, False);
   Set_Position (Main_Window, Win_Pos_None);
   Set_Modal (Main_Window, False);

   Gtk_New_Vbox (Main_Window.Vbox1, False, 0);
   Add (Main_Window, Main_Window.Vbox1);

   Gtk_New (Main_Window.Frame2, -"Source Date");
   Pack_Start (Main_Window.Vbox1, Main_Window.Frame2, True, True, 5);
   Set_Border_Width (Main_Window.Frame2, 3);
   Set_Shadow_Type (Main_Window.Frame2, Shadow_Etched_In);

   Gtk_New (Main_Window.Table2, 2, 5, False);
   Add (Main_Window.Frame2, Main_Window.Table2);
   Set_Row_Spacings (Main_Window.Table2, 0);
   Set_Col_Spacings (Main_Window.Table2, 0);

   Gtk_New (Main_Window.Label3, -("Date"));
   Attach (Main_Window.Table2, Main_Window.Label3, 0, 1, 0, 1,
     0, 0,
     0, 0);
   Set_Alignment (Main_Window.Label3, 0.5, 0.5);
   Set_Padding (Main_Window.Label3, 3, 0);
   Set_Justify (Main_Window.Label3, Justify_Right);
   Set_Line_Wrap (Main_Window.Label3, False);

   Gtk_New (Main_Window.Label4, -("UT"));
   Attach (Main_Window.Table2, Main_Window.Label4, 0, 1, 1, 2,
     0, 0,
     0, 0);
   Set_Alignment (Main_Window.Label4, 0.5, 0.5);
   Set_Padding (Main_Window.Label4, 0, 0);
   Set_Justify (Main_Window.Label4, Justify_Right);
   Set_Line_Wrap (Main_Window.Label4, False);

   Gtk_New (Main_Window.Source_Year);
   Set_USize (Main_Window.Source_Year, 40, 22);
   Attach (Main_Window.Table2, Main_Window.Source_Year, 4, 5, 0, 1,
     Shrink, 0,
     0, 0);
   Set_Editable (Main_Window.Source_Year, True);
   Set_Max_Length (Main_Window.Source_Year, 4);
   Set_Text (Main_Window.Source_Year, -"1900");
   Set_Visibility (Main_Window.Source_Year, True);

   Gtk_New (Main_Window.Source_Day);
   Set_USize (Main_Window.Source_Day, 40, 22);
   Attach (Main_Window.Table2, Main_Window.Source_Day, 1, 2, 0, 1,
     Shrink, 0,
     0, 0);
   Set_Editable (Main_Window.Source_Day, True);
   Set_Max_Length (Main_Window.Source_Day, 2);
   Set_Text (Main_Window.Source_Day, -"01");
   Set_Visibility (Main_Window.Source_Day, True);

   Gtk_New (Main_Window.Source_Hour);
   Set_USize (Main_Window.Source_Hour, 40, 22);
   Attach (Main_Window.Table2, Main_Window.Source_Hour, 1, 2, 1, 2,
     Shrink, 0,
     0, 0);
   Set_Editable (Main_Window.Source_Hour, True);
   Set_Max_Length (Main_Window.Source_Hour, 2);
   Set_Text (Main_Window.Source_Hour, -"00");
   Set_Visibility (Main_Window.Source_Hour, True);

   Gtk_New (Main_Window.Source_Minute);
   Set_USize (Main_Window.Source_Minute, 40, 22);
   Attach (Main_Window.Table2, Main_Window.Source_Minute, 2, 3, 1, 2,
     Shrink, 0,
     0, 0);
   Set_Editable (Main_Window.Source_Minute, True);
   Set_Max_Length (Main_Window.Source_Minute, 2);
   Set_Text (Main_Window.Source_Minute, -"00");
   Set_Visibility (Main_Window.Source_Minute, True);

   Gtk_New (Main_Window.Source_Second);
   Set_USize (Main_Window.Source_Second, 40, 22);
   Attach (Main_Window.Table2, Main_Window.Source_Second, 3, 4, 1, 2,
     Shrink, 0,
     0, 0);
   Set_Editable (Main_Window.Source_Second, True);
   Set_Max_Length (Main_Window.Source_Second, 2);
   Set_Text (Main_Window.Source_Second, -"00");
   Set_Visibility (Main_Window.Source_Second, True);

   Gtk_New (Main_Window.Combo2);
   Attach (Main_Window.Table2, Main_Window.Combo2, 2, 4, 0, 1,
     Shrink, 0,
     0, 0);
   Set_Case_Sensitive (Main_Window.Combo2, False);
   Set_Use_Arrows (Main_Window.Combo2, True);
   Set_Use_Arrows_Always (Main_Window.Combo2, False);
   String_List.Append (Combo2_Items, -"Jan");
   String_List.Append (Combo2_Items, -"Feb");
   String_List.Append (Combo2_Items, -"Mar");
   String_List.Append (Combo2_Items, -"Apr");
   String_List.Append (Combo2_Items, -"May");
   String_List.Append (Combo2_Items, -"Jun");
   String_List.Append (Combo2_Items, -"Jul");
   String_List.Append (Combo2_Items, -"Aug");
   String_List.Append (Combo2_Items, -"Sep");
   String_List.Append (Combo2_Items, -"Oct");
   String_List.Append (Combo2_Items, -"Nov");
   String_List.Append (Combo2_Items, -"Dec");
   Combo.Set_Popdown_Strings (Main_Window.Combo2, Combo2_Items);
   Free_String_List (Combo2_Items);

   Main_Window.Source_Month := Get_Entry (Main_Window.Combo2);
   Set_USize (Main_Window.Source_Month, 40, 22);
   Set_Editable (Main_Window.Source_Month, True);
   Set_Max_Length (Main_Window.Source_Month, 0);
   Set_Text (Main_Window.Source_Month, -"Jan");
   Set_Visibility (Main_Window.Source_Month, True);

   Gtk_New (Main_Window.Frame1, -"Radix");
   Pack_Start (Main_Window.Vbox1, Main_Window.Frame1, True, True, 5);
   Set_Border_Width (Main_Window.Frame1, 3);
   Set_Shadow_Type (Main_Window.Frame1, Shadow_Etched_In);

   Gtk_New (Main_Window.Table1, 2, 5, False);
   Add (Main_Window.Frame1, Main_Window.Table1);
   Set_Row_Spacings (Main_Window.Table1, 0);
   Set_Col_Spacings (Main_Window.Table1, 0);

   Gtk_New (Main_Window.Label1, -("Date"));
   Attach (Main_Window.Table1, Main_Window.Label1, 0, 1, 0, 1,
     0, 0,
     0, 0);
   Set_Alignment (Main_Window.Label1, 0.5, 0.5);
   Set_Padding (Main_Window.Label1, 3, 0);
   Set_Justify (Main_Window.Label1, Justify_Right);
   Set_Line_Wrap (Main_Window.Label1, False);

   Gtk_New (Main_Window.Label2, -("UT"));
   Attach (Main_Window.Table1, Main_Window.Label2, 0, 1, 1, 2,
     0, 0,
     0, 0);
   Set_Alignment (Main_Window.Label2, 0.5, 0.5);
   Set_Padding (Main_Window.Label2, 0, 0);
   Set_Justify (Main_Window.Label2, Justify_Right);
   Set_Line_Wrap (Main_Window.Label2, False);

   Gtk_New (Main_Window.Radix_Year);
   Set_USize (Main_Window.Radix_Year, 40, 22);
   Attach (Main_Window.Table1, Main_Window.Radix_Year, 4, 5, 0, 1,
     Shrink, 0,
     0, 0);
   Set_Editable (Main_Window.Radix_Year, True);
   Set_Max_Length (Main_Window.Radix_Year, 4);
   Set_Text (Main_Window.Radix_Year, -"1900");
   Set_Visibility (Main_Window.Radix_Year, True);

   Gtk_New (Main_Window.Radix_Day);
   Set_USize (Main_Window.Radix_Day, 40, 22);
   Attach (Main_Window.Table1, Main_Window.Radix_Day, 1, 2, 0, 1,
     Shrink, 0,
     0, 0);
   Set_Editable (Main_Window.Radix_Day, True);
   Set_Max_Length (Main_Window.Radix_Day, 2);
   Set_Text (Main_Window.Radix_Day, -"01");
   Set_Visibility (Main_Window.Radix_Day, True);

   Gtk_New (Main_Window.Radix_Hour);
   Set_USize (Main_Window.Radix_Hour, 40, 22);
   Attach (Main_Window.Table1, Main_Window.Radix_Hour, 1, 2, 1, 2,
     Shrink, 0,
     0, 0);
   Set_Editable (Main_Window.Radix_Hour, True);
   Set_Max_Length (Main_Window.Radix_Hour, 2);
   Set_Text (Main_Window.Radix_Hour, -"00");
   Set_Visibility (Main_Window.Radix_Hour, True);

   Gtk_New (Main_Window.Radix_Minute);
   Set_USize (Main_Window.Radix_Minute, 40, 22);
   Attach (Main_Window.Table1, Main_Window.Radix_Minute, 2, 3, 1, 2,
     Shrink, 0,
     0, 0);
   Set_Editable (Main_Window.Radix_Minute, True);
   Set_Max_Length (Main_Window.Radix_Minute, 2);
   Set_Text (Main_Window.Radix_Minute, -"00");
   Set_Visibility (Main_Window.Radix_Minute, True);

   Gtk_New (Main_Window.Combo1);
   Attach (Main_Window.Table1, Main_Window.Combo1, 2, 4, 0, 1,
     Shrink, 0,
     0, 0);
   Set_Case_Sensitive (Main_Window.Combo1, False);
   Set_Use_Arrows (Main_Window.Combo1, True);
   Set_Use_Arrows_Always (Main_Window.Combo1, False);
   String_List.Append (Combo1_Items, -"Jan");
   String_List.Append (Combo1_Items, -"Feb");
   String_List.Append (Combo1_Items, -"Mar");
   String_List.Append (Combo1_Items, -"Apr");
   String_List.Append (Combo1_Items, -"May");
   String_List.Append (Combo1_Items, -"Jun");
   String_List.Append (Combo1_Items, -"Jul");
   String_List.Append (Combo1_Items, -"Aug");
   String_List.Append (Combo1_Items, -"Sep");
   String_List.Append (Combo1_Items, -"Oct");
   String_List.Append (Combo1_Items, -"Nov");
   String_List.Append (Combo1_Items, -"Dec");
   Combo.Set_Popdown_Strings (Main_Window.Combo1, Combo1_Items);
   Free_String_List (Combo1_Items);

   Main_Window.Radix_Month := Get_Entry (Main_Window.Combo1);
   Set_USize (Main_Window.Radix_Month, 40, 22);
   Set_Editable (Main_Window.Radix_Month, True);
   Set_Max_Length (Main_Window.Radix_Month, 0);
   Set_Text (Main_Window.Radix_Month, -"Jan");
   Set_Visibility (Main_Window.Radix_Month, True);

   Gtk_New (Main_Window.Radix_Second);
   Set_USize (Main_Window.Radix_Second, 40, 22);
   Attach (Main_Window.Table1, Main_Window.Radix_Second, 3, 4, 1, 2,
     Shrink, 0,
     0, 0);
   Set_Editable (Main_Window.Radix_Second, True);
   Set_Max_Length (Main_Window.Radix_Second, 2);
   Set_Text (Main_Window.Radix_Second, -"00");
   Set_Visibility (Main_Window.Radix_Second, True);

   Gtk_New (Main_Window.Frame3, -"Reflection Date");
   Pack_Start (Main_Window.Vbox1, Main_Window.Frame3, True, True, 5);
   Set_Border_Width (Main_Window.Frame3, 3);
   Set_Shadow_Type (Main_Window.Frame3, Shadow_Etched_In);

   Gtk_New (Main_Window.Table3, 2, 5, False);
   Add (Main_Window.Frame3, Main_Window.Table3);
   Set_Row_Spacings (Main_Window.Table3, 0);
   Set_Col_Spacings (Main_Window.Table3, 0);

   Gtk_New (Main_Window.Label5, -("Date"));
   Attach (Main_Window.Table3, Main_Window.Label5, 0, 1, 0, 1,
     0, 0,
     0, 0);
   Set_Alignment (Main_Window.Label5, 0.5, 0.5);
   Set_Padding (Main_Window.Label5, 3, 0);
   Set_Justify (Main_Window.Label5, Justify_Right);
   Set_Line_Wrap (Main_Window.Label5, False);

   Gtk_New (Main_Window.Label6, -("UT"));
   Attach (Main_Window.Table3, Main_Window.Label6, 0, 1, 1, 2,
     0, 0,
     0, 0);
   Set_Alignment (Main_Window.Label6, 0.5, 0.5);
   Set_Padding (Main_Window.Label6, 0, 0);
   Set_Justify (Main_Window.Label6, Justify_Right);
   Set_Line_Wrap (Main_Window.Label6, False);

   Gtk_New (Main_Window.Reflection_Day);
   Attach (Main_Window.Table3, Main_Window.Reflection_Day, 1, 2, 0, 1,
     Shrink, 0,
     0, 0);
   Set_Alignment (Main_Window.Reflection_Day, 0.5, 0.5);
   Set_Padding (Main_Window.Reflection_Day, 0, 0);
   Set_Justify (Main_Window.Reflection_Day, Justify_Right);
   Set_Line_Wrap (Main_Window.Reflection_Day, False);

   Gtk_New (Main_Window.Reflection_Month);
   Attach (Main_Window.Table3, Main_Window.Reflection_Month, 2, 4, 0, 1,
     0, 0,
     0, 0);
   Set_Alignment (Main_Window.Reflection_Month, 0.5, 0.5);
   Set_Padding (Main_Window.Reflection_Month, 0, 0);
   Set_Justify (Main_Window.Reflection_Month, Justify_Right);
   Set_Line_Wrap (Main_Window.Reflection_Month, False);

   Gtk_New (Main_Window.Reflection_Year);
   Attach (Main_Window.Table3, Main_Window.Reflection_Year, 4, 5, 0, 1,
     0, Shrink,
     0, 0);
   Set_Alignment (Main_Window.Reflection_Year, 0.5, 0.5);
   Set_Padding (Main_Window.Reflection_Year, 0, 0);
   Set_Justify (Main_Window.Reflection_Year, Justify_Right);
   Set_Line_Wrap (Main_Window.Reflection_Year, False);

   Gtk_New (Main_Window.Reflection_Hour);
   Attach (Main_Window.Table3, Main_Window.Reflection_Hour, 1, 2, 1, 2,
     0, 0,
     0, 0);
   Set_Alignment (Main_Window.Reflection_Hour, 0.5, 0.5);
   Set_Padding (Main_Window.Reflection_Hour, 0, 0);
   Set_Justify (Main_Window.Reflection_Hour, Justify_Right);
   Set_Line_Wrap (Main_Window.Reflection_Hour, False);

   Gtk_New (Main_Window.Reflection_Minute);
   Attach (Main_Window.Table3, Main_Window.Reflection_Minute, 2, 3, 1, 2,
     0, 0,
     0, 0);
   Set_Alignment (Main_Window.Reflection_Minute, 0.5, 0.5);
   Set_Padding (Main_Window.Reflection_Minute, 0, 0);
   Set_Justify (Main_Window.Reflection_Minute, Justify_Right);
   Set_Line_Wrap (Main_Window.Reflection_Minute, False);

   Gtk_New (Main_Window.Reflection_Second);
   Attach (Main_Window.Table3, Main_Window.Reflection_Second, 3, 4, 1, 2,
     0, 0,
     0, 0);
   Set_Alignment (Main_Window.Reflection_Second, 0.5, 0.5);
   Set_Padding (Main_Window.Reflection_Second, 0, 0);
   Set_Justify (Main_Window.Reflection_Second, Justify_Right);
   Set_Line_Wrap (Main_Window.Reflection_Second, False);

   Gtk_New (Main_Window.Hbuttonbox1);
   Pack_Start (Main_Window.Vbox1, Main_Window.Hbuttonbox1, True, True, 0);
   Set_Spacing (Main_Window.Hbuttonbox1, 30);
   Set_Layout (Main_Window.Hbuttonbox1, Buttonbox_Default_Style);
   Set_Child_Size (Main_Window.Hbuttonbox1, 85, 27);
   Set_Child_Ipadding (Main_Window.Hbuttonbox1, 7, 0);

   Gtk_New (Main_Window.Calculate_Button, -"Calculate");
   Set_Flags (Main_Window.Calculate_Button, Can_Default);
   Button_Callback.Connect
     (Main_Window.Calculate_Button, "clicked",
      Button_Callback.To_Marshaller (On_Calculate_Button_Clicked'Access),
      Controller);
   Add (Main_Window.Hbuttonbox1, Main_Window.Calculate_Button);

end Initialize;

end Main_Window_Pkg;
