with MVC; use MVC;
with Publish_Subscribe; use Publish_Subscribe;
package Simple_MVC is
   type Simple_Model is new Model_Obj with private;

   procedure Trigger (M : access Simple_Model);

   type Simple_View is new View_Obj with private;

   procedure Update (V : access Simple_View;
                     S : access Observable'Class;
                     E : access Event'Class);

   function Triggered (V : access Simple_View) return Boolean;


   type Simple_Controller is new Controller_Obj with private;

   procedure Update (C : access Simple_Controller;
                     S : access Observable'Class;
                     E : access Event'Class);

   function Triggered (C : access Simple_Controller) return Boolean;
private

   type Simple_Model is new Model_Obj with null record;
   type Simple_View is new View_Obj with record
      Triggered : Boolean := False;
   end record;

   type Simple_Controller is new Controller_Obj with record
      Triggered : Boolean := False;
   end record;

end Simple_MVC;
