with AUnit.Test_Cases.Registration;
use AUnit.Test_Cases.Registration;

with AUnit.Assertions; use AUnit.Assertions;

with Times; use Times;
package body Test_Calendar_Conversions is

   --  .05 seconds
   Small_Delta : constant := 2.08E-7;

   -------------------
   -- Test Routines --
   -------------------

   --  Test a variety of conversions to Julian Day numbers
   procedure Test_JD (T : in out AUnit.Test_Cases.Test_Case'Class) is
      JD_UT : Long_Float;
   begin
      Jd_Ut := Gregorian_To_Julian_Day (1, Jan, 2000, 12.0);
      Assert (abs (Jd_Ut - 2451_545.0) < Small_Delta,
              "Failed for 1 Jan 2000 0.5" & ASCII.LF &
              "Expected: 2451545.0" & ASCII.LF &
              "Got: " & Long_Float'Image (Jd_Ut));

      Jd_Ut := Gregorian_To_Julian_Day (27, Jan, 1987, 0.0);
      Assert (abs (Jd_Ut - 2446_822.5) < Small_Delta,
              "Failed for 27 Jan 1987 0.0" & ASCII.LF &
              "Expected: 2446_822.5" & ASCII.LF &
              "Got: " & Long_Float'Image (Jd_Ut));

      Jd_Ut := Gregorian_To_Julian_Day (19, Jun, 1987, 12.0);
      Assert (abs (Jd_Ut - 2446_966.0) < Small_Delta,
              "Failed for 19 Jun 1987 0.5" & ASCII.LF &
              "Expected: 2446_966.0" & ASCII.LF &
              "Got: " & Long_Float'Image (Jd_Ut));

      Jd_Ut := Gregorian_To_Julian_Day (27, Jan, 1988, 0.0);
      Assert (abs (Jd_Ut - 2447_187.5) < Small_Delta,
              "Failed for 27 Jan 1988 0.0" & ASCII.LF &
              "Expected: 2447_187.5" & ASCII.LF &
              "Got: " & Long_Float'Image (Jd_Ut));

      Jd_Ut := Gregorian_To_Julian_Day (19, Jun, 1988, 12.0);
      Assert (abs (Jd_Ut - 2447_332.0) < Small_Delta,
              "Failed for 19 Jun 1988 0.5" & ASCII.LF &
              "Expected: 2447_332.0" & ASCII.LF &
              "Got: " & Long_Float'Image (Jd_Ut));

      Jd_Ut := Gregorian_To_Julian_Day (1, Jan, 1900, 0.0);
      Assert (abs (Jd_Ut - 2415_020.5) < Small_Delta,
              "Failed for 1 Jan 1900 0.0" & ASCII.LF &
              "Expected: 2415_020.5" & ASCII.LF &
              "Got: " & Long_Float'Image (Jd_Ut));

      Jd_Ut := Gregorian_To_Julian_Day (1, Jan, 1600, 0.0);
      Assert (abs (Jd_Ut - 2305_447.5) < Small_Delta,
              "Failed for 1 Jan 1600 0.0" & ASCII.LF &
              "Expected: 2305_447.5" & ASCII.LF &
              "Got: " & Long_Float'Image (Jd_Ut));

      Jd_Ut := Gregorian_To_Julian_Day (31, Dec, 1600, 0.0);
      Assert (abs (Jd_Ut - 2305_812.5) < Small_Delta,
              "Failed for 31 Dec 1600 0.0" & ASCII.LF &
              "Expected: 2305_812.5" & ASCII.LF &
              "Got: " & Long_Float'Image (Jd_Ut));

      Jd_Ut := Julian_To_Julian_Day (10, Apr, 837, 7.33333);
      Assert (abs (Jd_Ut - 2026_871.80555542) < Small_Delta,
              "Failed for 10 Apr 837 0.3" & ASCII.LF &
              "Expected: 2026_871.8" & ASCII.LF &
              "Got: " & Long_Float'Image (Jd_Ut));

      Jd_Ut := Julian_To_Julian_Day (12, Jul, -1000, 12.0);
      Assert (abs (Jd_Ut - 1356_001.0) < Small_Delta,
              "Failed for 12 Jul -1000 0.5" & ASCII.LF &
              "Expected: 1356_001.0" & ASCII.LF &
              "Got: " & Long_Float'Image (Jd_Ut));

      Jd_Ut := Julian_To_Julian_Day (29, Feb, -1000, 0.0);
      Assert (abs (Jd_Ut - 1355_866.5) < Small_Delta,
              "Failed for 29 Feb -1000 0.0" & ASCII.LF &
              "Expected: 1355_866.5" & ASCII.LF &
              "Got: " & Long_Float'Image (Jd_Ut));

      Jd_Ut := Julian_To_Julian_Day (17, Aug, -1001, 21.6);
      Assert (abs (Jd_Ut - 1355_671.4) < Small_Delta,
              "Failed for 17 Aug -1001 0.9" & ASCII.LF &
              "Expected: 1355_671.4" & ASCII.LF &
              "Got: " & Long_Float'Image (Jd_Ut));

      Jd_Ut := Julian_To_Julian_Day (1, Jan, -4712, 12.0);
      Assert (abs (Jd_Ut - 0.0) < Small_Delta,
              "Failed for 1 Jan -4712 0.5" & ASCII.LF &
              "Expected: 0.0" & ASCII.LF &
              "Got: " & Long_Float'Image (Jd_Ut));

   end Test_JD;

   procedure Register_Tests (T : in out Test_Case) is
   begin
      null;
      Register_Routine (T, Test_JD'Access, "Test Conversion to Julian Day");
   end Register_Tests;

   --  Identifier of test case:
   function Name (T : Test_Case) return String_Access is
   begin
      return new String'("Test Calendar Conversion");
   end Name;

end Test_Calendar_Conversions;
