with AUnit.Test_Cases.Registration;
use AUnit.Test_Cases.Registration;

with AUnit.Assertions; use AUnit.Assertions;

with MVC; use MVC;
with Simple_MVC; use Simple_MVC;

package body Test_MVC is


   -------------------
   -- Test Routines --
   -------------------


   procedure Test_Initialization
     (T : in out AUnit.Test_Cases.Test_Case'Class) is
      M : Model_Ptr := new Simple_Model;
      V : View_Ptr := new Simple_View;
      C : Controller_Ptr := new Simple_Controller;

   begin
      Initialize (V, M);
      Initialize (C, M, V);

      Assert (Model (V) = M, "Model not set correctly in view");
      Assert (Model (C) = M, "Model not set correctly in controller");
      Assert (View (C) = V, "View not set correctly in controller");
   end Test_Initialization;

   procedure Test_Update (T : in out AUnit.Test_Cases.Test_Case'Class) is
      M : aliased Simple_Model;
      V : aliased Simple_View;
      C : aliased Simple_Controller;

   begin
      Initialize (V'Unchecked_Access, M'Unchecked_Access);
      Add_Observer (M'Access, V'Unchecked_Access);
      Initialize (C'Unchecked_Access, M'Unchecked_Access, V'Unchecked_Access);
      Add_Observer (M'Access, C'Unchecked_Access);
      Trigger (M'Unchecked_Access);

      Assert (Triggered (V'Unchecked_Access), "View not updated");
      Assert (Triggered (C'Unchecked_Access), "Controller not updated");
   end Test_Update;

   procedure Register_Tests (T : in out Test_Case) is
   begin
      Register_Routine
        (T, Test_Initialization'Access, "Test MVC Initialization");
      Register_Routine (T, Test_Update'Access, "Test notification mechanism");
   end Register_Tests;

   --  Identifier of test case:
   function Name (T : Test_Case) return String_Access is
   begin
      return new String'("Test basic MVC");
   end Name;

end Test_MVC;
