------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                             FIELD_VALIDATION                             --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.3 $                             --
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with Times; use Times;
with Locations; use Locations;

--  Elementary validation of GTK+ field data
package body Field_Validation is

   ----------------------
   --  Implementation  --
   ----------------------

   -- Convert empty string to "0"
   function Zero_Empty (S : String) return String;


   ------------------------
   --  Basic Operations  --
   ------------------------

   function Validate_Day (S : String) return String is
      Result : String := Zero_Empty (S);
      Temp : Days;
   begin
      Temp := Days'Value (Result);
      return Result;
   exception
      when others =>
         raise Invalid_Date;
   end Validate_Day;


   function Validate_Month (S : String) return String is
      Temp : Months;
   begin
      Temp := Months'Value (S);
      return S;
   exception
      when others =>
         raise Invalid_Date;
   end Validate_Month;


   function Validate_Year (S : String) return String is
      Result : String := Zero_Empty (S);
      Temp : Years;
   begin
      Temp := Years'Value (Result);
      return Result;
   exception
      when others =>
         raise Invalid_Date;
   end Validate_Year;


   function Validate_Latitude (S : String) return String is
      type Latitude_Range is range 0 .. 90;
      Temp : Latitude_Range;
   begin
      Temp := Latitude_Range'Value (S);
      return S;
   exception
      when others =>
         raise Invalid_Latitude;
   end Validate_Latitude;


   function Validate_NS (S : String) return String is
      Temp : Latitude_Hemispheres;
   begin
      Temp := Latitude_Hemispheres'Value (S);
      return S;
   exception
      when others =>
         raise Invalid_Latitude;
   end Validate_NS;


   function Validate_Longitude (S : String) return String is
      type Longitude_Range is range 0 .. 180;
      Temp : Longitude_Range;
   begin
      Temp := Longitude_Range'Value (S);
      return S;
   exception
      when others =>
         raise Invalid_Longitude;
   end Validate_Longitude;


   function Validate_EW (S : String) return String is
      Temp : Longitude_Hemispheres;
   begin
      Temp := Longitude_Hemispheres'Value (S);
      return S;
   exception
      when others =>
         raise Invalid_Longitude;
   end Validate_EW;


   function Validate_Altitude (S : String) return String is
      Result : String := Zero_Empty (S);
      Temp : Integer;
   begin
      Temp := Integer'Value (Result);
      return Result;
   exception
      when others =>
         raise Invalid_Altitude;
   end Validate_Altitude;


   function Validate_Hour (S : String) return String is
      type Hour_Range is range 0 .. 23;
      Temp : Hour_Range;
      Str : String := Zero_Empty (S);
   begin
      Temp := Hour_Range'Value (Str);
      return Str;
   exception
      when others =>
         raise Invalid_Time;
   end Validate_Hour;


   function Validate_Sexagesimal (S : String) return String is
      type Sexagesimal_Range is range 0 .. 59;
      Temp : Sexagesimal_Range;
      Result : String := Zero_Empty (S);
   begin
      Temp := Sexagesimal_Range'Value (Result);
      return Result;
   exception
      when others =>
         raise Invalid_Time;
   end Validate_Sexagesimal;



   ----------------------
   --  Implementation  --
   ----------------------

   -- Convert empty string to "0"
   function Zero_Empty (S : String) return String is
   begin
      if S = "" or else S = (S'Range => ' ') then
         return "0";
      else
         return S;
      end if;
   end Zero_Empty;

end Field_Validation;
