------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                            LOCATIONS.STRINGS                             --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.3 $
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with Decimal_Sexagesimal; use Decimal_Sexagesimal;
with Ada.Strings.Fixed; use Ada.Strings, Ada.Strings.Fixed;

--  Conversions of location values and strings
package body Locations.Strings is

   -----------------
   --  Latitudes  --
   -----------------

   --  Latitude string with hemisphere label
   function Latitude_String (Lat : Latitudes) return String is
      Result : String := To_Degree_String (abs Lat) & "N ";
   begin
      if Lat < 0.0 then
         Result (Result'Length - 1) := 'S';
      end if;
      return Result;
   end Latitude_String;

   --  Latitude degrees string
   function Latitude_Degrees_String (Lat : Latitudes) return String is
      Temp : String :=  Latitude_String (Lat);
   begin
      return Temp (1 .. Index (Temp, " ") - 1);
   end Latitude_Degrees_String;

   --  Latitude minutes string
   function Latitude_Minutes_String (Lat : Latitudes) return String is
      Temp : String :=  Latitude_String (Lat);
   begin
      return Temp (Index (Temp, " ") + 1 .. Index (Temp, "'", Backward) - 1);
   end Latitude_Minutes_String;

   --  Latitude seconds string
   function Latitude_Seconds_String (Lat : Latitudes) return String is
      Temp : String :=  Latitude_String (Lat);
   begin
      return Temp (Index (Temp, "' ") + 2 .. Index (Temp, """", Backward) - 1);
   end Latitude_Seconds_String;


   --  Latitude hemisphere string
   function Latitude_Hemisphere_String (Lat : Latitudes) return String is
   begin
      if Lat < 0.0 then
         return "South";
      else
         return "North";
      end if;
   end Latitude_Hemisphere_String;


   ------------------
   --  Longitudes  --
   ------------------

   --  Longitude string with hemisphere label
   function Longitude_String (Long : Longitudes) return String is
      Result : String := To_Degree_String (abs Long) & "W ";
   begin
      if Long > 0.0 then
         Result (Result'Length - 1) := 'E';
      end if;
      return Result;
   end Longitude_String;

   --  Longitude degrees string
   function Longitude_Degrees_String (Long : Longitudes) return String is
      Temp : String :=  Longitude_String (Long);
   begin
      return Temp (1 .. Index (Temp, " ") - 1);
   end Longitude_Degrees_String;

   --  Longitude minutes string
   function Longitude_Minutes_String (Long : Longitudes) return String is
      Temp : String :=  Longitude_String (Long);
   begin
      return Temp (Index (Temp, " ") + 1 .. Index (Temp, "'", Backward) - 1);
   end Longitude_Minutes_String;

   --  Longitude seconds string
   function Longitude_Seconds_String (Long : Longitudes) return String is
      Temp : String :=  Longitude_String (Long);
   begin
      return Temp (Index (Temp, "' ") + 2 .. Index (Temp, """", Backward) - 1);
   end Longitude_Seconds_String;

   --  Longitude hemisphere string
   function Longitude_Hemisphere_String (Long : Longitudes) return String is
   begin
      if Long > 0.0 then
         return "East";
      else
         return "West";
      end if;
   end Longitude_Hemisphere_String;


   -----------------
   --  Altitudes  --
   -----------------

   --  Altitude string with units label
   function Altitude_String (Alt : Altitudes) return String is
   begin
      return
        Trim (Integer'Image (Integer (Alt)), Both) & "m ";
   end Altitude_String;

end Locations.Strings;
